﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/application-signals/model/ListServicesRequest.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ApplicationSignals::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListServicesRequest::SerializePayload() const { return {}; }

void ListServicesRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_startTimeHasBeenSet) {
    ss << m_startTime.ToGmtString(Aws::Utils::DateFormat::ISO_8601);
    uri.AddQueryStringParameter("StartTime", ss.str());
    ss.str("");
  }

  if (m_endTimeHasBeenSet) {
    ss << m_endTime.ToGmtString(Aws::Utils::DateFormat::ISO_8601);
    uri.AddQueryStringParameter("EndTime", ss.str());
    ss.str("");
  }

  if (m_maxResultsHasBeenSet) {
    ss << m_maxResults;
    uri.AddQueryStringParameter("MaxResults", ss.str());
    ss.str("");
  }

  if (m_nextTokenHasBeenSet) {
    ss << m_nextToken;
    uri.AddQueryStringParameter("NextToken", ss.str());
    ss.str("");
  }

  if (m_includeLinkedAccountsHasBeenSet) {
    ss << m_includeLinkedAccounts;
    uri.AddQueryStringParameter("IncludeLinkedAccounts", ss.str());
    ss.str("");
  }

  if (m_awsAccountIdHasBeenSet) {
    ss << m_awsAccountId;
    uri.AddQueryStringParameter("AwsAccountId", ss.str());
    ss.str("");
  }
}
