// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: Flight.proto
// Original file comments:
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
// <p>
// http://www.apache.org/licenses/LICENSE-2.0
// <p>
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_Flight_2eproto__INCLUDED
#define GRPC_Flight_2eproto__INCLUDED

#include "Flight.pb.h"

#include <functional>
#include <grpcpp/generic/async_generic_service.h>
#include <grpcpp/support/async_stream.h>
#include <grpcpp/support/async_unary_call.h>
#include <grpcpp/support/client_callback.h>
#include <grpcpp/client_context.h>
#include <grpcpp/completion_queue.h>
#include <grpcpp/support/message_allocator.h>
#include <grpcpp/support/method_handler.h>
#include <grpcpp/impl/proto_utils.h>
#include <grpcpp/impl/rpc_method.h>
#include <grpcpp/support/server_callback.h>
#include <grpcpp/impl/server_callback_handlers.h>
#include <grpcpp/server_context.h>
#include <grpcpp/impl/service_type.h>
#include <grpcpp/support/status.h>
#include <grpcpp/support/stub_options.h>
#include <grpcpp/support/sync_stream.h>
#include <grpcpp/ports_def.inc>

namespace arrow {
namespace flight {
namespace protocol {

//
// A flight service is an endpoint for retrieving or storing Arrow data. A
// flight service can expose one or more predefined endpoints that can be
// accessed using the Arrow Flight Protocol. Additionally, a flight service
// can expose a set of actions that are available.
class FlightService final {
 public:
  static constexpr char const* service_full_name() {
    return "arrow.flight.protocol.FlightService";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    //
    // Handshake between client and server. Depending on the server, the
    // handshake may be required to determine the token that should be used for
    // future operations. Both request and response are streams to allow multiple
    // round-trips depending on auth mechanism.
    std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>> Handshake(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>>(HandshakeRaw(context));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>> AsyncHandshake(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>>(AsyncHandshakeRaw(context, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>> PrepareAsyncHandshake(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>>(PrepareAsyncHandshakeRaw(context, cq));
    }
    //
    // Get a list of available streams given a particular criteria. Most flight
    // services will expose one or more streams that are readily available for
    // retrieval. This api allows listing the streams available for
    // consumption. A user can also provide a criteria. The criteria can limit
    // the subset of streams that can be listed via this interface. Each flight
    // service allows its own definition of how to consume criteria.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::FlightInfo>> ListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::FlightInfo>>(ListFlightsRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightInfo>> AsyncListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightInfo>>(AsyncListFlightsRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightInfo>> PrepareAsyncListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightInfo>>(PrepareAsyncListFlightsRaw(context, request, cq));
    }
    //
    // For a given FlightDescriptor, get information about how the flight can be
    // consumed. This is a useful interface if the consumer of the interface
    // already can identify the specific flight to consume. This interface can
    // also allow a consumer to generate a flight stream through a specified
    // descriptor. For example, a flight descriptor might be something that
    // includes a SQL statement or a Pickled Python operation that will be
    // executed. In those cases, the descriptor will not be previously available
    // within the list of available streams provided by ListFlights but will be
    // available for consumption for the duration defined by the specific flight
    // service.
    virtual ::grpc::Status GetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::arrow::flight::protocol::FlightInfo* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::FlightInfo>> AsyncGetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::FlightInfo>>(AsyncGetFlightInfoRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::FlightInfo>> PrepareAsyncGetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::FlightInfo>>(PrepareAsyncGetFlightInfoRaw(context, request, cq));
    }
    //
    // For a given FlightDescriptor, start a query and get information
    // to poll its execution status. This is a useful interface if the
    // query may be a long-running query. The first PollFlightInfo call
    // should return as quickly as possible. (GetFlightInfo doesn't
    // return until the query is complete.)
    //
    // A client can consume any available results before
    // the query is completed. See PollInfo.info for details.
    //
    // A client can poll the updated query status by calling
    // PollFlightInfo() with PollInfo.flight_descriptor. A server
    // should not respond until the result would be different from last
    // time. That way, the client can "long poll" for updates
    // without constantly making requests. Clients can set a short timeout
    // to avoid blocking calls if desired.
    //
    // A client can't use PollInfo.flight_descriptor after
    // PollInfo.expiration_time passes. A server might not accept the
    // retry descriptor anymore and the query may be cancelled.
    //
    // A client may use the CancelFlightInfo action with
    // PollInfo.info to cancel the running query.
    virtual ::grpc::Status PollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::arrow::flight::protocol::PollInfo* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::PollInfo>> AsyncPollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::PollInfo>>(AsyncPollFlightInfoRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::PollInfo>> PrepareAsyncPollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::PollInfo>>(PrepareAsyncPollFlightInfoRaw(context, request, cq));
    }
    //
    // For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
    // This is used when a consumer needs the Schema of flight stream. Similar to
    // GetFlightInfo this interface may generate a new flight that was not previously
    // available in ListFlights.
    virtual ::grpc::Status GetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::arrow::flight::protocol::SchemaResult* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::SchemaResult>> AsyncGetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::SchemaResult>>(AsyncGetSchemaRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::SchemaResult>> PrepareAsyncGetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::SchemaResult>>(PrepareAsyncGetSchemaRaw(context, request, cq));
    }
    //
    // Retrieve a single stream associated with a particular descriptor
    // associated with the referenced ticket. A Flight can be composed of one or
    // more streams where each stream can be retrieved using a separate opaque
    // ticket that the flight service uses for managing a collection of streams.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::FlightData>> DoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::FlightData>>(DoGetRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightData>> AsyncDoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightData>>(AsyncDoGetRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightData>> PrepareAsyncDoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightData>>(PrepareAsyncDoGetRaw(context, request, cq));
    }
    //
    // Push a stream to the flight service associated with a particular
    // flight stream. This allows a client of a flight service to upload a stream
    // of data. Depending on the particular flight service, a client consumer
    // could be allowed to upload a single stream per descriptor or an unlimited
    // number. In the latter, the service might implement a 'seal' action that
    // can be applied to a descriptor once all streams are uploaded.
    std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>> DoPut(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>>(DoPutRaw(context));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>> AsyncDoPut(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>>(AsyncDoPutRaw(context, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>> PrepareAsyncDoPut(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>>(PrepareAsyncDoPutRaw(context, cq));
    }
    //
    // Open a bidirectional data channel for a given descriptor. This
    // allows clients to send and receive arbitrary Arrow data and
    // application-specific metadata in a single logical stream. In
    // contrast to DoGet/DoPut, this is more suited for clients
    // offloading computation (rather than storage) to a Flight service.
    std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>> DoExchange(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>>(DoExchangeRaw(context));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>> AsyncDoExchange(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>>(AsyncDoExchangeRaw(context, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>> PrepareAsyncDoExchange(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>>(PrepareAsyncDoExchangeRaw(context, cq));
    }
    //
    // Flight services can support an arbitrary number of simple actions in
    // addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
    // operations that are potentially available. DoAction allows a flight client
    // to do a specific action against a flight service. An action includes
    // opaque request and response objects that are specific to the type action
    // being undertaken.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::Result>> DoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::Result>>(DoActionRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::Result>> AsyncDoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::Result>>(AsyncDoActionRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::Result>> PrepareAsyncDoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::Result>>(PrepareAsyncDoActionRaw(context, request, cq));
    }
    //
    // A flight service exposes all of the available action types that it has
    // along with descriptions. This allows different flight consumers to
    // understand the capabilities of the flight service.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::ActionType>> ListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::arrow::flight::protocol::ActionType>>(ListActionsRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::ActionType>> AsyncListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::ActionType>>(AsyncListActionsRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::ActionType>> PrepareAsyncListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::ActionType>>(PrepareAsyncListActionsRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      //
      // Handshake between client and server. Depending on the server, the
      // handshake may be required to determine the token that should be used for
      // future operations. Both request and response are streams to allow multiple
      // round-trips depending on auth mechanism.
      virtual void Handshake(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::arrow::flight::protocol::HandshakeRequest,::arrow::flight::protocol::HandshakeResponse>* reactor) = 0;
      //
      // Get a list of available streams given a particular criteria. Most flight
      // services will expose one or more streams that are readily available for
      // retrieval. This api allows listing the streams available for
      // consumption. A user can also provide a criteria. The criteria can limit
      // the subset of streams that can be listed via this interface. Each flight
      // service allows its own definition of how to consume criteria.
      virtual void ListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::FlightInfo>* reactor) = 0;
      //
      // For a given FlightDescriptor, get information about how the flight can be
      // consumed. This is a useful interface if the consumer of the interface
      // already can identify the specific flight to consume. This interface can
      // also allow a consumer to generate a flight stream through a specified
      // descriptor. For example, a flight descriptor might be something that
      // includes a SQL statement or a Pickled Python operation that will be
      // executed. In those cases, the descriptor will not be previously available
      // within the list of available streams provided by ListFlights but will be
      // available for consumption for the duration defined by the specific flight
      // service.
      virtual void GetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::FlightInfo* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::FlightInfo* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      //
      // For a given FlightDescriptor, start a query and get information
      // to poll its execution status. This is a useful interface if the
      // query may be a long-running query. The first PollFlightInfo call
      // should return as quickly as possible. (GetFlightInfo doesn't
      // return until the query is complete.)
      //
      // A client can consume any available results before
      // the query is completed. See PollInfo.info for details.
      //
      // A client can poll the updated query status by calling
      // PollFlightInfo() with PollInfo.flight_descriptor. A server
      // should not respond until the result would be different from last
      // time. That way, the client can "long poll" for updates
      // without constantly making requests. Clients can set a short timeout
      // to avoid blocking calls if desired.
      //
      // A client can't use PollInfo.flight_descriptor after
      // PollInfo.expiration_time passes. A server might not accept the
      // retry descriptor anymore and the query may be cancelled.
      //
      // A client may use the CancelFlightInfo action with
      // PollInfo.info to cancel the running query.
      virtual void PollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::PollInfo* response, std::function<void(::grpc::Status)>) = 0;
      virtual void PollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::PollInfo* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      //
      // For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
      // This is used when a consumer needs the Schema of flight stream. Similar to
      // GetFlightInfo this interface may generate a new flight that was not previously
      // available in ListFlights.
      virtual void GetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::SchemaResult* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::SchemaResult* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      //
      // Retrieve a single stream associated with a particular descriptor
      // associated with the referenced ticket. A Flight can be composed of one or
      // more streams where each stream can be retrieved using a separate opaque
      // ticket that the flight service uses for managing a collection of streams.
      virtual void DoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::FlightData>* reactor) = 0;
      //
      // Push a stream to the flight service associated with a particular
      // flight stream. This allows a client of a flight service to upload a stream
      // of data. Depending on the particular flight service, a client consumer
      // could be allowed to upload a single stream per descriptor or an unlimited
      // number. In the latter, the service might implement a 'seal' action that
      // can be applied to a descriptor once all streams are uploaded.
      virtual void DoPut(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::arrow::flight::protocol::FlightData,::arrow::flight::protocol::PutResult>* reactor) = 0;
      //
      // Open a bidirectional data channel for a given descriptor. This
      // allows clients to send and receive arbitrary Arrow data and
      // application-specific metadata in a single logical stream. In
      // contrast to DoGet/DoPut, this is more suited for clients
      // offloading computation (rather than storage) to a Flight service.
      virtual void DoExchange(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::arrow::flight::protocol::FlightData,::arrow::flight::protocol::FlightData>* reactor) = 0;
      //
      // Flight services can support an arbitrary number of simple actions in
      // addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
      // operations that are potentially available. DoAction allows a flight client
      // to do a specific action against a flight service. An action includes
      // opaque request and response objects that are specific to the type action
      // being undertaken.
      virtual void DoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::Result>* reactor) = 0;
      //
      // A flight service exposes all of the available action types that it has
      // along with descriptions. This allows different flight consumers to
      // understand the capabilities of the flight service.
      virtual void ListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::ActionType>* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>* HandshakeRaw(::grpc::ClientContext* context) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>* AsyncHandshakeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>* PrepareAsyncHandshakeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::arrow::flight::protocol::FlightInfo>* ListFlightsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightInfo>* AsyncListFlightsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightInfo>* PrepareAsyncListFlightsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::FlightInfo>* AsyncGetFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::FlightInfo>* PrepareAsyncGetFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::PollInfo>* AsyncPollFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::PollInfo>* PrepareAsyncPollFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::SchemaResult>* AsyncGetSchemaRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::arrow::flight::protocol::SchemaResult>* PrepareAsyncGetSchemaRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::arrow::flight::protocol::FlightData>* DoGetRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightData>* AsyncDoGetRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::FlightData>* PrepareAsyncDoGetRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>* DoPutRaw(::grpc::ClientContext* context) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>* AsyncDoPutRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>* PrepareAsyncDoPutRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* DoExchangeRaw(::grpc::ClientContext* context) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* AsyncDoExchangeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* PrepareAsyncDoExchangeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::arrow::flight::protocol::Result>* DoActionRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::Result>* AsyncDoActionRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::Result>* PrepareAsyncDoActionRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::arrow::flight::protocol::ActionType>* ListActionsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::ActionType>* AsyncListActionsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::arrow::flight::protocol::ActionType>* PrepareAsyncListActionsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    std::unique_ptr< ::grpc::ClientReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>> Handshake(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>>(HandshakeRaw(context));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>> AsyncHandshake(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>>(AsyncHandshakeRaw(context, cq, tag));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>> PrepareAsyncHandshake(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>>(PrepareAsyncHandshakeRaw(context, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::FlightInfo>> ListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::FlightInfo>>(ListFlightsRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightInfo>> AsyncListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightInfo>>(AsyncListFlightsRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightInfo>> PrepareAsyncListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightInfo>>(PrepareAsyncListFlightsRaw(context, request, cq));
    }
    ::grpc::Status GetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::arrow::flight::protocol::FlightInfo* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::FlightInfo>> AsyncGetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::FlightInfo>>(AsyncGetFlightInfoRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::FlightInfo>> PrepareAsyncGetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::FlightInfo>>(PrepareAsyncGetFlightInfoRaw(context, request, cq));
    }
    ::grpc::Status PollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::arrow::flight::protocol::PollInfo* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::PollInfo>> AsyncPollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::PollInfo>>(AsyncPollFlightInfoRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::PollInfo>> PrepareAsyncPollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::PollInfo>>(PrepareAsyncPollFlightInfoRaw(context, request, cq));
    }
    ::grpc::Status GetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::arrow::flight::protocol::SchemaResult* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::SchemaResult>> AsyncGetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::SchemaResult>>(AsyncGetSchemaRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::SchemaResult>> PrepareAsyncGetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::SchemaResult>>(PrepareAsyncGetSchemaRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::FlightData>> DoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::FlightData>>(DoGetRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightData>> AsyncDoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightData>>(AsyncDoGetRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightData>> PrepareAsyncDoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightData>>(PrepareAsyncDoGetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>> DoPut(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>>(DoPutRaw(context));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>> AsyncDoPut(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>>(AsyncDoPutRaw(context, cq, tag));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>> PrepareAsyncDoPut(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>>(PrepareAsyncDoPutRaw(context, cq));
    }
    std::unique_ptr< ::grpc::ClientReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>> DoExchange(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>>(DoExchangeRaw(context));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>> AsyncDoExchange(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>>(AsyncDoExchangeRaw(context, cq, tag));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>> PrepareAsyncDoExchange(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>>(PrepareAsyncDoExchangeRaw(context, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::Result>> DoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::Result>>(DoActionRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::Result>> AsyncDoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::Result>>(AsyncDoActionRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::Result>> PrepareAsyncDoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::Result>>(PrepareAsyncDoActionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::ActionType>> ListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::arrow::flight::protocol::ActionType>>(ListActionsRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::ActionType>> AsyncListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::ActionType>>(AsyncListActionsRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::ActionType>> PrepareAsyncListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::arrow::flight::protocol::ActionType>>(PrepareAsyncListActionsRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void Handshake(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::arrow::flight::protocol::HandshakeRequest,::arrow::flight::protocol::HandshakeResponse>* reactor) override;
      void ListFlights(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::FlightInfo>* reactor) override;
      void GetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::FlightInfo* response, std::function<void(::grpc::Status)>) override;
      void GetFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::FlightInfo* response, ::grpc::ClientUnaryReactor* reactor) override;
      void PollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::PollInfo* response, std::function<void(::grpc::Status)>) override;
      void PollFlightInfo(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::PollInfo* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::SchemaResult* response, std::function<void(::grpc::Status)>) override;
      void GetSchema(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::SchemaResult* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DoGet(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::FlightData>* reactor) override;
      void DoPut(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::arrow::flight::protocol::FlightData,::arrow::flight::protocol::PutResult>* reactor) override;
      void DoExchange(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::arrow::flight::protocol::FlightData,::arrow::flight::protocol::FlightData>* reactor) override;
      void DoAction(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::Result>* reactor) override;
      void ListActions(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty* request, ::grpc::ClientReadReactor< ::arrow::flight::protocol::ActionType>* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>* HandshakeRaw(::grpc::ClientContext* context) override;
    ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>* AsyncHandshakeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>* PrepareAsyncHandshakeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::arrow::flight::protocol::FlightInfo>* ListFlightsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightInfo>* AsyncListFlightsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightInfo>* PrepareAsyncListFlightsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Criteria& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::FlightInfo>* AsyncGetFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::FlightInfo>* PrepareAsyncGetFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::PollInfo>* AsyncPollFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::PollInfo>* PrepareAsyncPollFlightInfoRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::SchemaResult>* AsyncGetSchemaRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::arrow::flight::protocol::SchemaResult>* PrepareAsyncGetSchemaRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::FlightDescriptor& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::arrow::flight::protocol::FlightData>* DoGetRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightData>* AsyncDoGetRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::FlightData>* PrepareAsyncDoGetRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Ticket& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>* DoPutRaw(::grpc::ClientContext* context) override;
    ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>* AsyncDoPutRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>* PrepareAsyncDoPutRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* DoExchangeRaw(::grpc::ClientContext* context) override;
    ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* AsyncDoExchangeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* PrepareAsyncDoExchangeRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::arrow::flight::protocol::Result>* DoActionRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::Result>* AsyncDoActionRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::Result>* PrepareAsyncDoActionRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Action& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::arrow::flight::protocol::ActionType>* ListActionsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::ActionType>* AsyncListActionsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::arrow::flight::protocol::ActionType>* PrepareAsyncListActionsRaw(::grpc::ClientContext* context, const ::arrow::flight::protocol::Empty& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_Handshake_;
    const ::grpc::internal::RpcMethod rpcmethod_ListFlights_;
    const ::grpc::internal::RpcMethod rpcmethod_GetFlightInfo_;
    const ::grpc::internal::RpcMethod rpcmethod_PollFlightInfo_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSchema_;
    const ::grpc::internal::RpcMethod rpcmethod_DoGet_;
    const ::grpc::internal::RpcMethod rpcmethod_DoPut_;
    const ::grpc::internal::RpcMethod rpcmethod_DoExchange_;
    const ::grpc::internal::RpcMethod rpcmethod_DoAction_;
    const ::grpc::internal::RpcMethod rpcmethod_ListActions_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    //
    // Handshake between client and server. Depending on the server, the
    // handshake may be required to determine the token that should be used for
    // future operations. Both request and response are streams to allow multiple
    // round-trips depending on auth mechanism.
    virtual ::grpc::Status Handshake(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::HandshakeResponse, ::arrow::flight::protocol::HandshakeRequest>* stream);
    //
    // Get a list of available streams given a particular criteria. Most flight
    // services will expose one or more streams that are readily available for
    // retrieval. This api allows listing the streams available for
    // consumption. A user can also provide a criteria. The criteria can limit
    // the subset of streams that can be listed via this interface. Each flight
    // service allows its own definition of how to consume criteria.
    virtual ::grpc::Status ListFlights(::grpc::ServerContext* context, const ::arrow::flight::protocol::Criteria* request, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightInfo>* writer);
    //
    // For a given FlightDescriptor, get information about how the flight can be
    // consumed. This is a useful interface if the consumer of the interface
    // already can identify the specific flight to consume. This interface can
    // also allow a consumer to generate a flight stream through a specified
    // descriptor. For example, a flight descriptor might be something that
    // includes a SQL statement or a Pickled Python operation that will be
    // executed. In those cases, the descriptor will not be previously available
    // within the list of available streams provided by ListFlights but will be
    // available for consumption for the duration defined by the specific flight
    // service.
    virtual ::grpc::Status GetFlightInfo(::grpc::ServerContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::FlightInfo* response);
    //
    // For a given FlightDescriptor, start a query and get information
    // to poll its execution status. This is a useful interface if the
    // query may be a long-running query. The first PollFlightInfo call
    // should return as quickly as possible. (GetFlightInfo doesn't
    // return until the query is complete.)
    //
    // A client can consume any available results before
    // the query is completed. See PollInfo.info for details.
    //
    // A client can poll the updated query status by calling
    // PollFlightInfo() with PollInfo.flight_descriptor. A server
    // should not respond until the result would be different from last
    // time. That way, the client can "long poll" for updates
    // without constantly making requests. Clients can set a short timeout
    // to avoid blocking calls if desired.
    //
    // A client can't use PollInfo.flight_descriptor after
    // PollInfo.expiration_time passes. A server might not accept the
    // retry descriptor anymore and the query may be cancelled.
    //
    // A client may use the CancelFlightInfo action with
    // PollInfo.info to cancel the running query.
    virtual ::grpc::Status PollFlightInfo(::grpc::ServerContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::PollInfo* response);
    //
    // For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
    // This is used when a consumer needs the Schema of flight stream. Similar to
    // GetFlightInfo this interface may generate a new flight that was not previously
    // available in ListFlights.
    virtual ::grpc::Status GetSchema(::grpc::ServerContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::SchemaResult* response);
    //
    // Retrieve a single stream associated with a particular descriptor
    // associated with the referenced ticket. A Flight can be composed of one or
    // more streams where each stream can be retrieved using a separate opaque
    // ticket that the flight service uses for managing a collection of streams.
    virtual ::grpc::Status DoGet(::grpc::ServerContext* context, const ::arrow::flight::protocol::Ticket* request, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightData>* writer);
    //
    // Push a stream to the flight service associated with a particular
    // flight stream. This allows a client of a flight service to upload a stream
    // of data. Depending on the particular flight service, a client consumer
    // could be allowed to upload a single stream per descriptor or an unlimited
    // number. In the latter, the service might implement a 'seal' action that
    // can be applied to a descriptor once all streams are uploaded.
    virtual ::grpc::Status DoPut(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::PutResult, ::arrow::flight::protocol::FlightData>* stream);
    //
    // Open a bidirectional data channel for a given descriptor. This
    // allows clients to send and receive arbitrary Arrow data and
    // application-specific metadata in a single logical stream. In
    // contrast to DoGet/DoPut, this is more suited for clients
    // offloading computation (rather than storage) to a Flight service.
    virtual ::grpc::Status DoExchange(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* stream);
    //
    // Flight services can support an arbitrary number of simple actions in
    // addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
    // operations that are potentially available. DoAction allows a flight client
    // to do a specific action against a flight service. An action includes
    // opaque request and response objects that are specific to the type action
    // being undertaken.
    virtual ::grpc::Status DoAction(::grpc::ServerContext* context, const ::arrow::flight::protocol::Action* request, ::grpc::ServerWriter< ::arrow::flight::protocol::Result>* writer);
    //
    // A flight service exposes all of the available action types that it has
    // along with descriptions. This allows different flight consumers to
    // understand the capabilities of the flight service.
    virtual ::grpc::Status ListActions(::grpc::ServerContext* context, const ::arrow::flight::protocol::Empty* request, ::grpc::ServerWriter< ::arrow::flight::protocol::ActionType>* writer);
  };
  template <class BaseClass>
  class WithAsyncMethod_Handshake : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Handshake() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_Handshake() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Handshake(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::HandshakeResponse, ::arrow::flight::protocol::HandshakeRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestHandshake(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::arrow::flight::protocol::HandshakeResponse, ::arrow::flight::protocol::HandshakeRequest>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(0, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListFlights : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListFlights() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_ListFlights() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListFlights(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Criteria* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightInfo>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListFlights(::grpc::ServerContext* context, ::arrow::flight::protocol::Criteria* request, ::grpc::ServerAsyncWriter< ::arrow::flight::protocol::FlightInfo>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(1, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetFlightInfo() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_GetFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::FlightInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetFlightInfo(::grpc::ServerContext* context, ::arrow::flight::protocol::FlightDescriptor* request, ::grpc::ServerAsyncResponseWriter< ::arrow::flight::protocol::FlightInfo>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_PollFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_PollFlightInfo() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_PollFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PollFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::PollInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPollFlightInfo(::grpc::ServerContext* context, ::arrow::flight::protocol::FlightDescriptor* request, ::grpc::ServerAsyncResponseWriter< ::arrow::flight::protocol::PollInfo>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSchema : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSchema() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_GetSchema() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSchema(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::SchemaResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSchema(::grpc::ServerContext* context, ::arrow::flight::protocol::FlightDescriptor* request, ::grpc::ServerAsyncResponseWriter< ::arrow::flight::protocol::SchemaResult>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DoGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DoGet() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_DoGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoGet(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Ticket* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightData>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoGet(::grpc::ServerContext* context, ::arrow::flight::protocol::Ticket* request, ::grpc::ServerAsyncWriter< ::arrow::flight::protocol::FlightData>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(5, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DoPut : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DoPut() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_DoPut() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoPut(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::PutResult, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoPut(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::arrow::flight::protocol::PutResult, ::arrow::flight::protocol::FlightData>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(6, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DoExchange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DoExchange() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_DoExchange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoExchange(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoExchange(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(7, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DoAction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DoAction() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_DoAction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoAction(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Action* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::Result>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoAction(::grpc::ServerContext* context, ::arrow::flight::protocol::Action* request, ::grpc::ServerAsyncWriter< ::arrow::flight::protocol::Result>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(8, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListActions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListActions() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_ListActions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListActions(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Empty* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::ActionType>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListActions(::grpc::ServerContext* context, ::arrow::flight::protocol::Empty* request, ::grpc::ServerAsyncWriter< ::arrow::flight::protocol::ActionType>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(9, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_Handshake<WithAsyncMethod_ListFlights<WithAsyncMethod_GetFlightInfo<WithAsyncMethod_PollFlightInfo<WithAsyncMethod_GetSchema<WithAsyncMethod_DoGet<WithAsyncMethod_DoPut<WithAsyncMethod_DoExchange<WithAsyncMethod_DoAction<WithAsyncMethod_ListActions<Service > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_Handshake : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Handshake() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackBidiHandler< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->Handshake(context); }));
    }
    ~WithCallbackMethod_Handshake() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Handshake(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::HandshakeResponse, ::arrow::flight::protocol::HandshakeRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::arrow::flight::protocol::HandshakeRequest, ::arrow::flight::protocol::HandshakeResponse>* Handshake(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListFlights : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListFlights() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackServerStreamingHandler< ::arrow::flight::protocol::Criteria, ::arrow::flight::protocol::FlightInfo>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::arrow::flight::protocol::Criteria* request) { return this->ListFlights(context, request); }));
    }
    ~WithCallbackMethod_ListFlights() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListFlights(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Criteria* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightInfo>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::arrow::flight::protocol::FlightInfo>* ListFlights(
      ::grpc::CallbackServerContext* /*context*/, const ::arrow::flight::protocol::Criteria* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetFlightInfo() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::FlightInfo>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::FlightInfo* response) { return this->GetFlightInfo(context, request, response); }));}
    void SetMessageAllocatorFor_GetFlightInfo(
        ::grpc::MessageAllocator< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::FlightInfo>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::FlightInfo>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::FlightInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetFlightInfo(
      ::grpc::CallbackServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::FlightInfo* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_PollFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_PollFlightInfo() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::PollInfo>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::PollInfo* response) { return this->PollFlightInfo(context, request, response); }));}
    void SetMessageAllocatorFor_PollFlightInfo(
        ::grpc::MessageAllocator< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::PollInfo>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::PollInfo>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_PollFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PollFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::PollInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PollFlightInfo(
      ::grpc::CallbackServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::PollInfo* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSchema : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSchema() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::SchemaResult>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::arrow::flight::protocol::FlightDescriptor* request, ::arrow::flight::protocol::SchemaResult* response) { return this->GetSchema(context, request, response); }));}
    void SetMessageAllocatorFor_GetSchema(
        ::grpc::MessageAllocator< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::SchemaResult>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::SchemaResult>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSchema() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSchema(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::SchemaResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSchema(
      ::grpc::CallbackServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::SchemaResult* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DoGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DoGet() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackServerStreamingHandler< ::arrow::flight::protocol::Ticket, ::arrow::flight::protocol::FlightData>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::arrow::flight::protocol::Ticket* request) { return this->DoGet(context, request); }));
    }
    ~WithCallbackMethod_DoGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoGet(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Ticket* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightData>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::arrow::flight::protocol::FlightData>* DoGet(
      ::grpc::CallbackServerContext* /*context*/, const ::arrow::flight::protocol::Ticket* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DoPut : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DoPut() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackBidiHandler< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->DoPut(context); }));
    }
    ~WithCallbackMethod_DoPut() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoPut(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::PutResult, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::PutResult>* DoPut(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DoExchange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DoExchange() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackBidiHandler< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->DoExchange(context); }));
    }
    ~WithCallbackMethod_DoExchange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoExchange(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* DoExchange(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DoAction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DoAction() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackServerStreamingHandler< ::arrow::flight::protocol::Action, ::arrow::flight::protocol::Result>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::arrow::flight::protocol::Action* request) { return this->DoAction(context, request); }));
    }
    ~WithCallbackMethod_DoAction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoAction(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Action* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::Result>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::arrow::flight::protocol::Result>* DoAction(
      ::grpc::CallbackServerContext* /*context*/, const ::arrow::flight::protocol::Action* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListActions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListActions() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackServerStreamingHandler< ::arrow::flight::protocol::Empty, ::arrow::flight::protocol::ActionType>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::arrow::flight::protocol::Empty* request) { return this->ListActions(context, request); }));
    }
    ~WithCallbackMethod_ListActions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListActions(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Empty* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::ActionType>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::arrow::flight::protocol::ActionType>* ListActions(
      ::grpc::CallbackServerContext* /*context*/, const ::arrow::flight::protocol::Empty* /*request*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_Handshake<WithCallbackMethod_ListFlights<WithCallbackMethod_GetFlightInfo<WithCallbackMethod_PollFlightInfo<WithCallbackMethod_GetSchema<WithCallbackMethod_DoGet<WithCallbackMethod_DoPut<WithCallbackMethod_DoExchange<WithCallbackMethod_DoAction<WithCallbackMethod_ListActions<Service > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_Handshake : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Handshake() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_Handshake() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Handshake(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::HandshakeResponse, ::arrow::flight::protocol::HandshakeRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListFlights : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListFlights() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_ListFlights() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListFlights(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Criteria* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightInfo>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetFlightInfo() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_GetFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::FlightInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_PollFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_PollFlightInfo() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_PollFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PollFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::PollInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSchema : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSchema() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_GetSchema() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSchema(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::SchemaResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DoGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DoGet() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_DoGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoGet(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Ticket* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightData>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DoPut : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DoPut() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_DoPut() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoPut(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::PutResult, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DoExchange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DoExchange() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_DoExchange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoExchange(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DoAction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DoAction() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_DoAction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoAction(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Action* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::Result>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListActions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListActions() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_ListActions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListActions(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Empty* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::ActionType>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_Handshake : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Handshake() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_Handshake() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Handshake(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::HandshakeResponse, ::arrow::flight::protocol::HandshakeRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestHandshake(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(0, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListFlights : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListFlights() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_ListFlights() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListFlights(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Criteria* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightInfo>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListFlights(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(1, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetFlightInfo() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_GetFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::FlightInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetFlightInfo(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_PollFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_PollFlightInfo() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_PollFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PollFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::PollInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPollFlightInfo(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSchema : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSchema() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_GetSchema() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSchema(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::SchemaResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSchema(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DoGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DoGet() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_DoGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoGet(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Ticket* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightData>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoGet(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(5, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DoPut : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DoPut() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_DoPut() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoPut(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::PutResult, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoPut(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(6, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DoExchange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DoExchange() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_DoExchange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoExchange(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoExchange(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(7, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DoAction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DoAction() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_DoAction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoAction(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Action* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::Result>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDoAction(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(8, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListActions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListActions() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_ListActions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListActions(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Empty* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::ActionType>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListActions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(9, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Handshake : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Handshake() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackBidiHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->Handshake(context); }));
    }
    ~WithRawCallbackMethod_Handshake() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Handshake(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::HandshakeResponse, ::arrow::flight::protocol::HandshakeRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* Handshake(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListFlights : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListFlights() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->ListFlights(context, request); }));
    }
    ~WithRawCallbackMethod_ListFlights() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListFlights(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Criteria* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightInfo>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* ListFlights(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetFlightInfo() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetFlightInfo(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::FlightInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetFlightInfo(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_PollFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_PollFlightInfo() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->PollFlightInfo(context, request, response); }));
    }
    ~WithRawCallbackMethod_PollFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PollFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::PollInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PollFlightInfo(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSchema : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSchema() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSchema(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSchema() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSchema(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::SchemaResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSchema(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DoGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DoGet() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->DoGet(context, request); }));
    }
    ~WithRawCallbackMethod_DoGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoGet(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Ticket* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightData>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* DoGet(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DoPut : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DoPut() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackBidiHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->DoPut(context); }));
    }
    ~WithRawCallbackMethod_DoPut() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoPut(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::PutResult, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* DoPut(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DoExchange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DoExchange() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackBidiHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->DoExchange(context); }));
    }
    ~WithRawCallbackMethod_DoExchange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoExchange(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::arrow::flight::protocol::FlightData, ::arrow::flight::protocol::FlightData>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* DoExchange(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DoAction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DoAction() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->DoAction(context, request); }));
    }
    ~WithRawCallbackMethod_DoAction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DoAction(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Action* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::Result>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* DoAction(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListActions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListActions() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->ListActions(context, request); }));
    }
    ~WithRawCallbackMethod_ListActions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListActions(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Empty* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::ActionType>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* ListActions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetFlightInfo() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::FlightInfo>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::FlightInfo>* streamer) {
                       return this->StreamedGetFlightInfo(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::FlightInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetFlightInfo(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::arrow::flight::protocol::FlightDescriptor,::arrow::flight::protocol::FlightInfo>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_PollFlightInfo : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_PollFlightInfo() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::PollInfo>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::PollInfo>* streamer) {
                       return this->StreamedPollFlightInfo(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_PollFlightInfo() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status PollFlightInfo(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::PollInfo* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedPollFlightInfo(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::arrow::flight::protocol::FlightDescriptor,::arrow::flight::protocol::PollInfo>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSchema : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSchema() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::SchemaResult>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::arrow::flight::protocol::FlightDescriptor, ::arrow::flight::protocol::SchemaResult>* streamer) {
                       return this->StreamedGetSchema(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSchema() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSchema(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::FlightDescriptor* /*request*/, ::arrow::flight::protocol::SchemaResult* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSchema(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::arrow::flight::protocol::FlightDescriptor,::arrow::flight::protocol::SchemaResult>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_GetFlightInfo<WithStreamedUnaryMethod_PollFlightInfo<WithStreamedUnaryMethod_GetSchema<Service > > > StreamedUnaryService;
  template <class BaseClass>
  class WithSplitStreamingMethod_ListFlights : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_ListFlights() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::arrow::flight::protocol::Criteria, ::arrow::flight::protocol::FlightInfo>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::arrow::flight::protocol::Criteria, ::arrow::flight::protocol::FlightInfo>* streamer) {
                       return this->StreamedListFlights(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_ListFlights() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListFlights(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Criteria* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightInfo>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedListFlights(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::arrow::flight::protocol::Criteria,::arrow::flight::protocol::FlightInfo>* server_split_streamer) = 0;
  };
  template <class BaseClass>
  class WithSplitStreamingMethod_DoGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_DoGet() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::arrow::flight::protocol::Ticket, ::arrow::flight::protocol::FlightData>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::arrow::flight::protocol::Ticket, ::arrow::flight::protocol::FlightData>* streamer) {
                       return this->StreamedDoGet(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_DoGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DoGet(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Ticket* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::FlightData>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedDoGet(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::arrow::flight::protocol::Ticket,::arrow::flight::protocol::FlightData>* server_split_streamer) = 0;
  };
  template <class BaseClass>
  class WithSplitStreamingMethod_DoAction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_DoAction() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::arrow::flight::protocol::Action, ::arrow::flight::protocol::Result>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::arrow::flight::protocol::Action, ::arrow::flight::protocol::Result>* streamer) {
                       return this->StreamedDoAction(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_DoAction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DoAction(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Action* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::Result>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedDoAction(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::arrow::flight::protocol::Action,::arrow::flight::protocol::Result>* server_split_streamer) = 0;
  };
  template <class BaseClass>
  class WithSplitStreamingMethod_ListActions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_ListActions() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::arrow::flight::protocol::Empty, ::arrow::flight::protocol::ActionType>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::arrow::flight::protocol::Empty, ::arrow::flight::protocol::ActionType>* streamer) {
                       return this->StreamedListActions(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_ListActions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListActions(::grpc::ServerContext* /*context*/, const ::arrow::flight::protocol::Empty* /*request*/, ::grpc::ServerWriter< ::arrow::flight::protocol::ActionType>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedListActions(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::arrow::flight::protocol::Empty,::arrow::flight::protocol::ActionType>* server_split_streamer) = 0;
  };
  typedef WithSplitStreamingMethod_ListFlights<WithSplitStreamingMethod_DoGet<WithSplitStreamingMethod_DoAction<WithSplitStreamingMethod_ListActions<Service > > > > SplitStreamedService;
  typedef WithSplitStreamingMethod_ListFlights<WithStreamedUnaryMethod_GetFlightInfo<WithStreamedUnaryMethod_PollFlightInfo<WithStreamedUnaryMethod_GetSchema<WithSplitStreamingMethod_DoGet<WithSplitStreamingMethod_DoAction<WithSplitStreamingMethod_ListActions<Service > > > > > > > StreamedService;
};

}  // namespace protocol
}  // namespace flight
}  // namespace arrow


#include <grpcpp/ports_undef.inc>
#endif  // GRPC_Flight_2eproto__INCLUDED
