// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: cc/arduino/cli/commands/v1/board.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BoardDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The fully qualified board name of the board you want information about
	// (e.g., `arduino:avr:uno`).
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// If set to true the returned build properties will be left unexpanded, with
	// the variables placeholders exactly as defined in the platform.
	DoNotExpandBuildProperties bool `protobuf:"varint,3,opt,name=do_not_expand_build_properties,json=doNotExpandBuildProperties,proto3" json:"do_not_expand_build_properties,omitempty"`
}

func (x *BoardDetailsRequest) Reset() {
	*x = BoardDetailsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardDetailsRequest) ProtoMessage() {}

func (x *BoardDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardDetailsRequest.ProtoReflect.Descriptor instead.
func (*BoardDetailsRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{0}
}

func (x *BoardDetailsRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BoardDetailsRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *BoardDetailsRequest) GetDoNotExpandBuildProperties() bool {
	if x != nil {
		return x.DoNotExpandBuildProperties
	}
	return false
}

type BoardDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully qualified board name of the board.
	Fqbn string `protobuf:"bytes,1,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Name used to identify the board to humans (e.g., Arduino Uno).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Installed version of the board's platform.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// The board ID component of the FQBN (e.g., `uno`).
	PropertiesId string `protobuf:"bytes,4,opt,name=properties_id,json=propertiesId,proto3" json:"properties_id,omitempty"`
	// Board alias that can be used as a more user friendly alternative to the
	// FQBN.
	Alias string `protobuf:"bytes,5,opt,name=alias,proto3" json:"alias,omitempty"`
	// Whether this is an official or 3rd party board.
	Official bool `protobuf:"varint,6,opt,name=official,proto3" json:"official,omitempty"`
	// URL of the board's pinout documentation.
	Pinout string `protobuf:"bytes,7,opt,name=pinout,proto3" json:"pinout,omitempty"`
	// Data about the package that contains the board's platform.
	Package *Package `protobuf:"bytes,8,opt,name=package,proto3" json:"package,omitempty"`
	// Data about the board's platform.
	Platform *BoardPlatform `protobuf:"bytes,9,opt,name=platform,proto3" json:"platform,omitempty"`
	// Tool dependencies of the board.
	ToolsDependencies []*ToolsDependencies `protobuf:"bytes,10,rep,name=tools_dependencies,json=toolsDependencies,proto3" json:"tools_dependencies,omitempty"`
	// The board's custom configuration options.
	ConfigOptions []*ConfigOption `protobuf:"bytes,11,rep,name=config_options,json=configOptions,proto3" json:"config_options,omitempty"`
	// List of programmers supported by the board.
	Programmers []*Programmer `protobuf:"bytes,13,rep,name=programmers,proto3" json:"programmers,omitempty"`
	// Identifying information for the board (e.g., USB VID/PID).
	IdentificationProperties []*BoardIdentificationProperties `protobuf:"bytes,15,rep,name=identification_properties,json=identificationProperties,proto3" json:"identification_properties,omitempty"`
	// Board build properties used for compiling.
	BuildProperties []string `protobuf:"bytes,16,rep,name=build_properties,json=buildProperties,proto3" json:"build_properties,omitempty"`
	// Default programmer for the board.
	DefaultProgrammerId string `protobuf:"bytes,17,opt,name=default_programmer_id,json=defaultProgrammerId,proto3" json:"default_programmer_id,omitempty"`
}

func (x *BoardDetailsResponse) Reset() {
	*x = BoardDetailsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardDetailsResponse) ProtoMessage() {}

func (x *BoardDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardDetailsResponse.ProtoReflect.Descriptor instead.
func (*BoardDetailsResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{1}
}

func (x *BoardDetailsResponse) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *BoardDetailsResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BoardDetailsResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *BoardDetailsResponse) GetPropertiesId() string {
	if x != nil {
		return x.PropertiesId
	}
	return ""
}

func (x *BoardDetailsResponse) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *BoardDetailsResponse) GetOfficial() bool {
	if x != nil {
		return x.Official
	}
	return false
}

func (x *BoardDetailsResponse) GetPinout() string {
	if x != nil {
		return x.Pinout
	}
	return ""
}

func (x *BoardDetailsResponse) GetPackage() *Package {
	if x != nil {
		return x.Package
	}
	return nil
}

func (x *BoardDetailsResponse) GetPlatform() *BoardPlatform {
	if x != nil {
		return x.Platform
	}
	return nil
}

func (x *BoardDetailsResponse) GetToolsDependencies() []*ToolsDependencies {
	if x != nil {
		return x.ToolsDependencies
	}
	return nil
}

func (x *BoardDetailsResponse) GetConfigOptions() []*ConfigOption {
	if x != nil {
		return x.ConfigOptions
	}
	return nil
}

func (x *BoardDetailsResponse) GetProgrammers() []*Programmer {
	if x != nil {
		return x.Programmers
	}
	return nil
}

func (x *BoardDetailsResponse) GetIdentificationProperties() []*BoardIdentificationProperties {
	if x != nil {
		return x.IdentificationProperties
	}
	return nil
}

func (x *BoardDetailsResponse) GetBuildProperties() []string {
	if x != nil {
		return x.BuildProperties
	}
	return nil
}

func (x *BoardDetailsResponse) GetDefaultProgrammerId() string {
	if x != nil {
		return x.DefaultProgrammerId
	}
	return ""
}

type BoardIdentificationProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of properties that must all be matched to identify the board.
	Properties map[string]string `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BoardIdentificationProperties) Reset() {
	*x = BoardIdentificationProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardIdentificationProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardIdentificationProperties) ProtoMessage() {}

func (x *BoardIdentificationProperties) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardIdentificationProperties.ProtoReflect.Descriptor instead.
func (*BoardIdentificationProperties) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{2}
}

func (x *BoardIdentificationProperties) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

type Package struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maintainer of the package.
	Maintainer string `protobuf:"bytes,1,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	// The URL of the platforms index file
	// (e.g., https://downloads.arduino.cc/packages/package_index.json).
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// A URL provided by the package author, intended to point to their website.
	WebsiteUrl string `protobuf:"bytes,3,opt,name=website_url,json=websiteUrl,proto3" json:"website_url,omitempty"`
	// Email address of the package maintainer.
	Email string `protobuf:"bytes,4,opt,name=email,proto3" json:"email,omitempty"`
	// Package vendor name.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Resources for getting help about using the package.
	Help *Help `protobuf:"bytes,6,opt,name=help,proto3" json:"help,omitempty"`
}

func (x *Package) Reset() {
	*x = Package{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{3}
}

func (x *Package) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *Package) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Package) GetWebsiteUrl() string {
	if x != nil {
		return x.WebsiteUrl
	}
	return ""
}

func (x *Package) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *Package) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Package) GetHelp() *Help {
	if x != nil {
		return x.Help
	}
	return nil
}

type Help struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL for getting online help.
	Online string `protobuf:"bytes,1,opt,name=online,proto3" json:"online,omitempty"`
}

func (x *Help) Reset() {
	*x = Help{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Help) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Help) ProtoMessage() {}

func (x *Help) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Help.ProtoReflect.Descriptor instead.
func (*Help) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{4}
}

func (x *Help) GetOnline() string {
	if x != nil {
		return x.Online
	}
	return ""
}

type BoardPlatform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Architecture of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,1,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Category of the platform. Set to `Contributed` for 3rd party platforms.
	Category string `protobuf:"bytes,2,opt,name=category,proto3" json:"category,omitempty"`
	// Download URL of the platform archive file.
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// File name of the platform archive.
	ArchiveFilename string `protobuf:"bytes,4,opt,name=archive_filename,json=archiveFilename,proto3" json:"archive_filename,omitempty"`
	// Checksum of the platform archive.
	Checksum string `protobuf:"bytes,5,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// File size of the platform archive.
	Size int64 `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
	// Name used to identify the platform to humans.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *BoardPlatform) Reset() {
	*x = BoardPlatform{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardPlatform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardPlatform) ProtoMessage() {}

func (x *BoardPlatform) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardPlatform.ProtoReflect.Descriptor instead.
func (*BoardPlatform) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{5}
}

func (x *BoardPlatform) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *BoardPlatform) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *BoardPlatform) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *BoardPlatform) GetArchiveFilename() string {
	if x != nil {
		return x.ArchiveFilename
	}
	return ""
}

func (x *BoardPlatform) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

func (x *BoardPlatform) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *BoardPlatform) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type ToolsDependencies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Vendor name of the package containing the tool definition.
	Packager string `protobuf:"bytes,1,opt,name=packager,proto3" json:"packager,omitempty"`
	// Tool name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Tool version.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Data for the operating system-specific builds of the tool.
	Systems []*Systems `protobuf:"bytes,4,rep,name=systems,proto3" json:"systems,omitempty"`
}

func (x *ToolsDependencies) Reset() {
	*x = ToolsDependencies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolsDependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolsDependencies) ProtoMessage() {}

func (x *ToolsDependencies) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolsDependencies.ProtoReflect.Descriptor instead.
func (*ToolsDependencies) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{6}
}

func (x *ToolsDependencies) GetPackager() string {
	if x != nil {
		return x.Packager
	}
	return ""
}

func (x *ToolsDependencies) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ToolsDependencies) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ToolsDependencies) GetSystems() []*Systems {
	if x != nil {
		return x.Systems
	}
	return nil
}

type Systems struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Checksum of the tool archive.
	Checksum string `protobuf:"bytes,1,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// Operating system identifier.
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// File name of the tool archive.
	ArchiveFilename string `protobuf:"bytes,3,opt,name=archive_filename,json=archiveFilename,proto3" json:"archive_filename,omitempty"`
	// Download URL of the tool archive.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// File size of the tool archive.
	Size int64 `protobuf:"varint,5,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *Systems) Reset() {
	*x = Systems{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Systems) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Systems) ProtoMessage() {}

func (x *Systems) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Systems.ProtoReflect.Descriptor instead.
func (*Systems) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{7}
}

func (x *Systems) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

func (x *Systems) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Systems) GetArchiveFilename() string {
	if x != nil {
		return x.ArchiveFilename
	}
	return ""
}

func (x *Systems) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Systems) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

type ConfigOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the configuration option. For identifying the option to machines.
	Option string `protobuf:"bytes,1,opt,name=option,proto3" json:"option,omitempty"`
	// Name of the configuration option for identifying the option to humans.
	OptionLabel string `protobuf:"bytes,2,opt,name=option_label,json=optionLabel,proto3" json:"option_label,omitempty"`
	// Possible values of the configuration option.
	Values []*ConfigValue `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ConfigOption) Reset() {
	*x = ConfigOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigOption) ProtoMessage() {}

func (x *ConfigOption) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigOption.ProtoReflect.Descriptor instead.
func (*ConfigOption) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{8}
}

func (x *ConfigOption) GetOption() string {
	if x != nil {
		return x.Option
	}
	return ""
}

func (x *ConfigOption) GetOptionLabel() string {
	if x != nil {
		return x.OptionLabel
	}
	return ""
}

func (x *ConfigOption) GetValues() []*ConfigValue {
	if x != nil {
		return x.Values
	}
	return nil
}

type ConfigValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration option value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Label to identify the configuration option to humans.
	ValueLabel string `protobuf:"bytes,2,opt,name=value_label,json=valueLabel,proto3" json:"value_label,omitempty"`
	// Whether the configuration option is selected.
	Selected bool `protobuf:"varint,3,opt,name=selected,proto3" json:"selected,omitempty"`
}

func (x *ConfigValue) Reset() {
	*x = ConfigValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigValue) ProtoMessage() {}

func (x *ConfigValue) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigValue.ProtoReflect.Descriptor instead.
func (*ConfigValue) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{9}
}

func (x *ConfigValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *ConfigValue) GetValueLabel() string {
	if x != nil {
		return x.ValueLabel
	}
	return ""
}

func (x *ConfigValue) GetSelected() bool {
	if x != nil {
		return x.Selected
	}
	return false
}

type BoardListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Search for boards for the given time (in milliseconds).
	Timeout int64 `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The fully qualified board name of the board you want information about
	// (e.g., `arduino:avr:uno`).
	Fqbn string `protobuf:"bytes,3,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// If set to true, when a board cannot be identified using the installed
	// platforms, the cloud API will not be called to detect the board.
	SkipCloudApiForBoardDetection bool `protobuf:"varint,4,opt,name=skip_cloud_api_for_board_detection,json=skipCloudApiForBoardDetection,proto3" json:"skip_cloud_api_for_board_detection,omitempty"`
}

func (x *BoardListRequest) Reset() {
	*x = BoardListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardListRequest) ProtoMessage() {}

func (x *BoardListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardListRequest.ProtoReflect.Descriptor instead.
func (*BoardListRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{10}
}

func (x *BoardListRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BoardListRequest) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

func (x *BoardListRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *BoardListRequest) GetSkipCloudApiForBoardDetection() bool {
	if x != nil {
		return x.SkipCloudApiForBoardDetection
	}
	return false
}

type BoardListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ports and the boards detected on those ports.
	Ports []*DetectedPort `protobuf:"bytes,1,rep,name=ports,proto3" json:"ports,omitempty"`
	// Warning messages or errors coming from the discoveries.
	Warnings []string `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *BoardListResponse) Reset() {
	*x = BoardListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardListResponse) ProtoMessage() {}

func (x *BoardListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardListResponse.ProtoReflect.Descriptor instead.
func (*BoardListResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{11}
}

func (x *BoardListResponse) GetPorts() []*DetectedPort {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *BoardListResponse) GetWarnings() []string {
	if x != nil {
		return x.Warnings
	}
	return nil
}

type DetectedPort struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The possible boards attached to the port.
	MatchingBoards []*BoardListItem `protobuf:"bytes,1,rep,name=matching_boards,json=matchingBoards,proto3" json:"matching_boards,omitempty"`
	// The port details.
	Port *Port `protobuf:"bytes,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *DetectedPort) Reset() {
	*x = DetectedPort{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectedPort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectedPort) ProtoMessage() {}

func (x *DetectedPort) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectedPort.ProtoReflect.Descriptor instead.
func (*DetectedPort) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{12}
}

func (x *DetectedPort) GetMatchingBoards() []*BoardListItem {
	if x != nil {
		return x.MatchingBoards
	}
	return nil
}

func (x *DetectedPort) GetPort() *Port {
	if x != nil {
		return x.Port
	}
	return nil
}

type BoardListAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The search query to filter the board list by.
	SearchArgs []string `protobuf:"bytes,2,rep,name=search_args,json=searchArgs,proto3" json:"search_args,omitempty"`
	// Set to true to get also the boards marked as "hidden" in the platform.
	IncludeHiddenBoards bool `protobuf:"varint,3,opt,name=include_hidden_boards,json=includeHiddenBoards,proto3" json:"include_hidden_boards,omitempty"`
}

func (x *BoardListAllRequest) Reset() {
	*x = BoardListAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardListAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardListAllRequest) ProtoMessage() {}

func (x *BoardListAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardListAllRequest.ProtoReflect.Descriptor instead.
func (*BoardListAllRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{13}
}

func (x *BoardListAllRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BoardListAllRequest) GetSearchArgs() []string {
	if x != nil {
		return x.SearchArgs
	}
	return nil
}

func (x *BoardListAllRequest) GetIncludeHiddenBoards() bool {
	if x != nil {
		return x.IncludeHiddenBoards
	}
	return false
}

type BoardListAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of installed boards.
	Boards []*BoardListItem `protobuf:"bytes,1,rep,name=boards,proto3" json:"boards,omitempty"`
}

func (x *BoardListAllResponse) Reset() {
	*x = BoardListAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardListAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardListAllResponse) ProtoMessage() {}

func (x *BoardListAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardListAllResponse.ProtoReflect.Descriptor instead.
func (*BoardListAllResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{14}
}

func (x *BoardListAllResponse) GetBoards() []*BoardListItem {
	if x != nil {
		return x.Boards
	}
	return nil
}

type BoardListWatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// If set to true, when a board cannot be identified using the installed
	// platforms, the cloud API will not be called to detect the board.
	SkipCloudApiForBoardDetection bool `protobuf:"varint,2,opt,name=skip_cloud_api_for_board_detection,json=skipCloudApiForBoardDetection,proto3" json:"skip_cloud_api_for_board_detection,omitempty"`
}

func (x *BoardListWatchRequest) Reset() {
	*x = BoardListWatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardListWatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardListWatchRequest) ProtoMessage() {}

func (x *BoardListWatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardListWatchRequest.ProtoReflect.Descriptor instead.
func (*BoardListWatchRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{15}
}

func (x *BoardListWatchRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BoardListWatchRequest) GetSkipCloudApiForBoardDetection() bool {
	if x != nil {
		return x.SkipCloudApiForBoardDetection
	}
	return false
}

type BoardListWatchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Event type as received from the serial discovery tool.
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Information about the port.
	Port *DetectedPort `protobuf:"bytes,2,opt,name=port,proto3" json:"port,omitempty"`
	// Eventual errors when detecting connected boards.
	Error string `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *BoardListWatchResponse) Reset() {
	*x = BoardListWatchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardListWatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardListWatchResponse) ProtoMessage() {}

func (x *BoardListWatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardListWatchResponse.ProtoReflect.Descriptor instead.
func (*BoardListWatchResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{16}
}

func (x *BoardListWatchResponse) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *BoardListWatchResponse) GetPort() *DetectedPort {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *BoardListWatchResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type BoardListItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name for use when identifying the board to a human.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fully qualified board name. Used to identify the board to a machine.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// If the board is marked as "hidden" in the platform.
	IsHidden bool `protobuf:"varint,3,opt,name=is_hidden,json=isHidden,proto3" json:"is_hidden,omitempty"`
	// Platform this board belongs to.
	Platform *Platform `protobuf:"bytes,6,opt,name=platform,proto3" json:"platform,omitempty"`
}

func (x *BoardListItem) Reset() {
	*x = BoardListItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardListItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardListItem) ProtoMessage() {}

func (x *BoardListItem) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardListItem.ProtoReflect.Descriptor instead.
func (*BoardListItem) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{17}
}

func (x *BoardListItem) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BoardListItem) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *BoardListItem) GetIsHidden() bool {
	if x != nil {
		return x.IsHidden
	}
	return false
}

func (x *BoardListItem) GetPlatform() *Platform {
	if x != nil {
		return x.Platform
	}
	return nil
}

type BoardSearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The search query to filter the board list by.
	SearchArgs string `protobuf:"bytes,2,opt,name=search_args,json=searchArgs,proto3" json:"search_args,omitempty"`
	// Set to true to get also the boards marked as "hidden" in installed
	// platforms.
	IncludeHiddenBoards bool `protobuf:"varint,3,opt,name=include_hidden_boards,json=includeHiddenBoards,proto3" json:"include_hidden_boards,omitempty"`
}

func (x *BoardSearchRequest) Reset() {
	*x = BoardSearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardSearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardSearchRequest) ProtoMessage() {}

func (x *BoardSearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardSearchRequest.ProtoReflect.Descriptor instead.
func (*BoardSearchRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{18}
}

func (x *BoardSearchRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BoardSearchRequest) GetSearchArgs() string {
	if x != nil {
		return x.SearchArgs
	}
	return ""
}

func (x *BoardSearchRequest) GetIncludeHiddenBoards() bool {
	if x != nil {
		return x.IncludeHiddenBoards
	}
	return false
}

type BoardSearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of installed and installable boards.
	Boards []*BoardListItem `protobuf:"bytes,1,rep,name=boards,proto3" json:"boards,omitempty"`
}

func (x *BoardSearchResponse) Reset() {
	*x = BoardSearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardSearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardSearchResponse) ProtoMessage() {}

func (x *BoardSearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardSearchResponse.ProtoReflect.Descriptor instead.
func (*BoardSearchResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{19}
}

func (x *BoardSearchResponse) GetBoards() []*BoardListItem {
	if x != nil {
		return x.Boards
	}
	return nil
}

type BoardIdentifyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// A set of properties to search (can be taken from a Port message).
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If set to true, when a board cannot be identified using the installed
	// platforms, the cloud API will be called to detect the board.
	UseCloudApiForUnknownBoardDetection bool `protobuf:"varint,3,opt,name=use_cloud_api_for_unknown_board_detection,json=useCloudApiForUnknownBoardDetection,proto3" json:"use_cloud_api_for_unknown_board_detection,omitempty"`
}

func (x *BoardIdentifyRequest) Reset() {
	*x = BoardIdentifyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardIdentifyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardIdentifyRequest) ProtoMessage() {}

func (x *BoardIdentifyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardIdentifyRequest.ProtoReflect.Descriptor instead.
func (*BoardIdentifyRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{20}
}

func (x *BoardIdentifyRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BoardIdentifyRequest) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *BoardIdentifyRequest) GetUseCloudApiForUnknownBoardDetection() bool {
	if x != nil {
		return x.UseCloudApiForUnknownBoardDetection
	}
	return false
}

type BoardIdentifyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of matching boards (they may have an FQBN with options set).
	Boards []*BoardListItem `protobuf:"bytes,1,rep,name=boards,proto3" json:"boards,omitempty"`
}

func (x *BoardIdentifyResponse) Reset() {
	*x = BoardIdentifyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoardIdentifyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoardIdentifyResponse) ProtoMessage() {}

func (x *BoardIdentifyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_board_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoardIdentifyResponse.ProtoReflect.Descriptor instead.
func (*BoardIdentifyResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP(), []int{21}
}

func (x *BoardIdentifyResponse) GetBoards() []*BoardListItem {
	if x != nil {
		return x.Boards
	}
	return nil
}

var File_cc_arduino_cli_commands_v1_board_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_board_proto_rawDesc = []byte{
	0x0a, 0x26, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x63,
	0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x01, 0x0a, 0x13, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71,
	0x62, 0x6e, 0x12, 0x42, 0x0a, 0x1e, 0x64, 0x6f, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x64, 0x6f, 0x4e, 0x6f,
	0x74, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0xa3, 0x06, 0x0a, 0x14, 0x42, 0x6f, 0x61, 0x72, 0x64,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66,
	0x71, 0x62, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x69, 0x6e, 0x6f,
	0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x69, 0x6e, 0x6f, 0x75, 0x74,
	0x12, 0x3d, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12,
	0x45, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x6f, 0x61, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x08, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x5c, 0x0a, 0x12, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x5f,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x52, 0x11, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x6d, 0x65, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d,
	0x65, 0x72, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x12,
	0x76, 0x0a, 0x19, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x6f, 0x61, 0x72, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x18, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x4a, 0x04, 0x08, 0x0e, 0x10, 0x0f, 0x22, 0xc9, 0x01, 0x0a,
	0x1d, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x69,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x49, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x6f, 0x61, 0x72, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xbc, 0x01, 0x0a, 0x07, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
	0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x65, 0x62,
	0x73, 0x69, 0x74, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x34, 0x0a, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x6c,
	0x70, 0x52, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x22, 0x1e, 0x0a, 0x04, 0x48, 0x65, 0x6c, 0x70, 0x12,
	0x16, 0x0a, 0x06, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x0d, 0x42, 0x6f, 0x61, 0x72,
	0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x11, 0x54,
	0x6f, 0x6f, 0x6c, 0x73, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x07, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73,
	0x52, 0x07, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x8a, 0x01, 0x0a, 0x07, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x21, 0x0a, 0x0c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x3f, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x22, 0x60, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x22, 0xcd, 0x01, 0x0a, 0x10, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x12, 0x49, 0x0a, 0x22, 0x73, 0x6b,
	0x69, 0x70, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x66, 0x6f, 0x72,
	0x5f, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1d, 0x73, 0x6b, 0x69, 0x70, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x41, 0x70, 0x69, 0x46, 0x6f, 0x72, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x0a, 0x11, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50,
	0x6f, 0x72, 0x74, 0x52, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x61,
	0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x77, 0x61,
	0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x98, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x52, 0x0a, 0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f,
	0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0e, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x12, 0x34, 0x0a, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x22, 0xac, 0x01, 0x0a, 0x13, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x72, 0x67, 0x73, 0x12, 0x32, 0x0a, 0x15,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x5f, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x48, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x73,
	0x22, 0x59, 0x0a, 0x14, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x74, 0x65, 0x6d, 0x52, 0x06, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x15,
	0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x49, 0x0a, 0x22, 0x73, 0x6b, 0x69, 0x70, 0x5f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x1d, 0x73, 0x6b, 0x69, 0x70, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x41, 0x70,
	0x69, 0x46, 0x6f, 0x72, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x8b, 0x01, 0x0a, 0x16, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74,
	0x57, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3c, 0x0a, 0x04,
	0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x50, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0x96, 0x01, 0x0a, 0x0d, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x74,
	0x65, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73,
	0x5f, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69,
	0x73, 0x48, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52,
	0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x22, 0xab, 0x01, 0x0a, 0x12, 0x42, 0x6f,
	0x61, 0x72, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x72, 0x67,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x72, 0x67, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x68,
	0x69, 0x64, 0x64, 0x65, 0x6e, 0x5f, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x48, 0x69, 0x64, 0x64, 0x65,
	0x6e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x22, 0x58, 0x0a, 0x13, 0x42, 0x6f, 0x61, 0x72, 0x64,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41,
	0x0a, 0x06, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72,
	0x64, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x06, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x22, 0xd1, 0x02, 0x0a, 0x14, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x60, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f,
	0x61, 0x72, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x56,
	0x0a, 0x29, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61, 0x70, 0x69, 0x5f,
	0x66, 0x6f, 0x72, 0x5f, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x23, 0x75, 0x73, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x41, 0x70, 0x69, 0x46, 0x6f,
	0x72, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5a, 0x0a, 0x15, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41,
	0x0a, 0x06, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72,
	0x64, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x06, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x42, 0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d,
	0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f,
	0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_board_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_board_proto_rawDescData = file_cc_arduino_cli_commands_v1_board_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_board_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_board_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_board_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_board_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_board_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_board_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_cc_arduino_cli_commands_v1_board_proto_goTypes = []any{
	(*BoardDetailsRequest)(nil),           // 0: cc.arduino.cli.commands.v1.BoardDetailsRequest
	(*BoardDetailsResponse)(nil),          // 1: cc.arduino.cli.commands.v1.BoardDetailsResponse
	(*BoardIdentificationProperties)(nil), // 2: cc.arduino.cli.commands.v1.BoardIdentificationProperties
	(*Package)(nil),                       // 3: cc.arduino.cli.commands.v1.Package
	(*Help)(nil),                          // 4: cc.arduino.cli.commands.v1.Help
	(*BoardPlatform)(nil),                 // 5: cc.arduino.cli.commands.v1.BoardPlatform
	(*ToolsDependencies)(nil),             // 6: cc.arduino.cli.commands.v1.ToolsDependencies
	(*Systems)(nil),                       // 7: cc.arduino.cli.commands.v1.Systems
	(*ConfigOption)(nil),                  // 8: cc.arduino.cli.commands.v1.ConfigOption
	(*ConfigValue)(nil),                   // 9: cc.arduino.cli.commands.v1.ConfigValue
	(*BoardListRequest)(nil),              // 10: cc.arduino.cli.commands.v1.BoardListRequest
	(*BoardListResponse)(nil),             // 11: cc.arduino.cli.commands.v1.BoardListResponse
	(*DetectedPort)(nil),                  // 12: cc.arduino.cli.commands.v1.DetectedPort
	(*BoardListAllRequest)(nil),           // 13: cc.arduino.cli.commands.v1.BoardListAllRequest
	(*BoardListAllResponse)(nil),          // 14: cc.arduino.cli.commands.v1.BoardListAllResponse
	(*BoardListWatchRequest)(nil),         // 15: cc.arduino.cli.commands.v1.BoardListWatchRequest
	(*BoardListWatchResponse)(nil),        // 16: cc.arduino.cli.commands.v1.BoardListWatchResponse
	(*BoardListItem)(nil),                 // 17: cc.arduino.cli.commands.v1.BoardListItem
	(*BoardSearchRequest)(nil),            // 18: cc.arduino.cli.commands.v1.BoardSearchRequest
	(*BoardSearchResponse)(nil),           // 19: cc.arduino.cli.commands.v1.BoardSearchResponse
	(*BoardIdentifyRequest)(nil),          // 20: cc.arduino.cli.commands.v1.BoardIdentifyRequest
	(*BoardIdentifyResponse)(nil),         // 21: cc.arduino.cli.commands.v1.BoardIdentifyResponse
	nil,                                   // 22: cc.arduino.cli.commands.v1.BoardIdentificationProperties.PropertiesEntry
	nil,                                   // 23: cc.arduino.cli.commands.v1.BoardIdentifyRequest.PropertiesEntry
	(*Instance)(nil),                      // 24: cc.arduino.cli.commands.v1.Instance
	(*Programmer)(nil),                    // 25: cc.arduino.cli.commands.v1.Programmer
	(*Port)(nil),                          // 26: cc.arduino.cli.commands.v1.Port
	(*Platform)(nil),                      // 27: cc.arduino.cli.commands.v1.Platform
}
var file_cc_arduino_cli_commands_v1_board_proto_depIdxs = []int32{
	24, // 0: cc.arduino.cli.commands.v1.BoardDetailsRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	3,  // 1: cc.arduino.cli.commands.v1.BoardDetailsResponse.package:type_name -> cc.arduino.cli.commands.v1.Package
	5,  // 2: cc.arduino.cli.commands.v1.BoardDetailsResponse.platform:type_name -> cc.arduino.cli.commands.v1.BoardPlatform
	6,  // 3: cc.arduino.cli.commands.v1.BoardDetailsResponse.tools_dependencies:type_name -> cc.arduino.cli.commands.v1.ToolsDependencies
	8,  // 4: cc.arduino.cli.commands.v1.BoardDetailsResponse.config_options:type_name -> cc.arduino.cli.commands.v1.ConfigOption
	25, // 5: cc.arduino.cli.commands.v1.BoardDetailsResponse.programmers:type_name -> cc.arduino.cli.commands.v1.Programmer
	2,  // 6: cc.arduino.cli.commands.v1.BoardDetailsResponse.identification_properties:type_name -> cc.arduino.cli.commands.v1.BoardIdentificationProperties
	22, // 7: cc.arduino.cli.commands.v1.BoardIdentificationProperties.properties:type_name -> cc.arduino.cli.commands.v1.BoardIdentificationProperties.PropertiesEntry
	4,  // 8: cc.arduino.cli.commands.v1.Package.help:type_name -> cc.arduino.cli.commands.v1.Help
	7,  // 9: cc.arduino.cli.commands.v1.ToolsDependencies.systems:type_name -> cc.arduino.cli.commands.v1.Systems
	9,  // 10: cc.arduino.cli.commands.v1.ConfigOption.values:type_name -> cc.arduino.cli.commands.v1.ConfigValue
	24, // 11: cc.arduino.cli.commands.v1.BoardListRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	12, // 12: cc.arduino.cli.commands.v1.BoardListResponse.ports:type_name -> cc.arduino.cli.commands.v1.DetectedPort
	17, // 13: cc.arduino.cli.commands.v1.DetectedPort.matching_boards:type_name -> cc.arduino.cli.commands.v1.BoardListItem
	26, // 14: cc.arduino.cli.commands.v1.DetectedPort.port:type_name -> cc.arduino.cli.commands.v1.Port
	24, // 15: cc.arduino.cli.commands.v1.BoardListAllRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 16: cc.arduino.cli.commands.v1.BoardListAllResponse.boards:type_name -> cc.arduino.cli.commands.v1.BoardListItem
	24, // 17: cc.arduino.cli.commands.v1.BoardListWatchRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	12, // 18: cc.arduino.cli.commands.v1.BoardListWatchResponse.port:type_name -> cc.arduino.cli.commands.v1.DetectedPort
	27, // 19: cc.arduino.cli.commands.v1.BoardListItem.platform:type_name -> cc.arduino.cli.commands.v1.Platform
	24, // 20: cc.arduino.cli.commands.v1.BoardSearchRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 21: cc.arduino.cli.commands.v1.BoardSearchResponse.boards:type_name -> cc.arduino.cli.commands.v1.BoardListItem
	24, // 22: cc.arduino.cli.commands.v1.BoardIdentifyRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	23, // 23: cc.arduino.cli.commands.v1.BoardIdentifyRequest.properties:type_name -> cc.arduino.cli.commands.v1.BoardIdentifyRequest.PropertiesEntry
	17, // 24: cc.arduino.cli.commands.v1.BoardIdentifyResponse.boards:type_name -> cc.arduino.cli.commands.v1.BoardListItem
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_board_proto_init() }
func file_cc_arduino_cli_commands_v1_board_proto_init() {
	if File_cc_arduino_cli_commands_v1_board_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	file_cc_arduino_cli_commands_v1_port_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*BoardDetailsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*BoardDetailsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*BoardIdentificationProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*Package); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Help); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*BoardPlatform); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ToolsDependencies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Systems); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ConfigValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*BoardListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*BoardListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*DetectedPort); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*BoardListAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*BoardListAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*BoardListWatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*BoardListWatchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*BoardListItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*BoardSearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*BoardSearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*BoardIdentifyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_board_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*BoardIdentifyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_board_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_board_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_board_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_board_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_board_proto = out.File
	file_cc_arduino_cli_commands_v1_board_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_board_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_board_proto_depIdxs = nil
}
