/* do not edit automatically generated by mc from P2SymBuild.  */
/* P2SymBuild.def pass 2 symbol creation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_P2SymBuild_H)
#   define _P2SymBuild_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif


#   if defined (_P2SymBuild_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   BlockStart - tokno is the module/procedure/implementation/definition token
*/

EXTERN void P2SymBuild_BlockStart (unsigned int tokno);

/*
   BlockEnd - declare module ctor/init/fini/dep procedures.
*/

EXTERN void P2SymBuild_BlockEnd (unsigned int tokno);

/*
   BlockBegin - assign curBeginTok to tokno.
*/

EXTERN void P2SymBuild_BlockBegin (unsigned int tokno);

/*
   BlockFinally - assign curFinallyTok to tokno.
*/

EXTERN void P2SymBuild_BlockFinally (unsigned int tokno);
EXTERN void P2SymBuild_P2StartBuildDefModule (void);
EXTERN void P2SymBuild_P2EndBuildDefModule (void);
EXTERN void P2SymBuild_P2StartBuildImplementationModule (void);
EXTERN void P2SymBuild_P2EndBuildImplementationModule (void);
EXTERN void P2SymBuild_P2StartBuildProgramModule (void);
EXTERN void P2SymBuild_P2EndBuildProgramModule (void);

/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

EXTERN void P2SymBuild_StartBuildInnerModule (void);

/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

EXTERN void P2SymBuild_EndBuildInnerModule (void);

/*
   BuildImportOuterModule - Builds imported identifiers into an outer module
                            from a definition module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                                                  Error Condition
                            Exit

                            All above stack discarded
*/

EXTERN void P2SymBuild_BuildImportOuterModule (void);

/*
   BuildExportOuterModule - Builds exported identifiers from an outer module
                            to the outside world of library modules.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;

                            Error Condition


                            Exit

                            All above stack discarded
*/

EXTERN void P2SymBuild_BuildExportOuterModule (void);

/*
   BuildImportInnerModule - Builds imported identifiers into an inner module
                            from the last level of module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                                                  Error Condition
                            Exit

                            All above stack discarded
*/

EXTERN void P2SymBuild_BuildImportInnerModule (void);

/*
   BuildExportInnerModule - Builds exported identifiers from an inner module
                            to the next layer module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

EXTERN void P2SymBuild_BuildExportInnerModule (void);

/*
   BuildNumber - Converts a number into a symbol.


                 Stack

                 Entry                 Exit

          Ptr ->                                      <- Ptr
                 +------------+        +------------+
                 | Name       |        | Sym        |
                 |------------+        |------------|
*/

EXTERN void P2SymBuild_BuildNumber (void);

/*
   BuildString - Converts a string into a symbol.


                 Stack

                 Entry                 Exit

          Ptr ->                                      <- Ptr
                 +------------+        +------------+
                 | Name       |        | Sym        |
                 |------------+        |------------|
*/

EXTERN void P2SymBuild_BuildString (void);

/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->
                +------------+
                | Name       |
                |------------+                       <- Ptr
*/

EXTERN void P2SymBuild_BuildConst (void);

/*
   StartBuildEnumeration - Builds an Enumeration type Type.


                           Stack

                           Entry                 Exit

                    Ptr ->
                           +------------+
                           | #          |
                           |------------|
                           | en 1       |
                           |------------|
                           | en 2       |
                           |------------|
                           .            .
                           .            .
                           .            .                       <- Ptr
                           |------------|        +------------+
                           | en #       |        | Type       |
                           |------------|        |------------|
                           | Name       |        | Name       |
                           |------------|        |------------|
*/

EXTERN void P2SymBuild_StartBuildEnumeration (void);

/*
   BuildSubrange - Builds a Subrange type Symbol, the base type can also be
                   supplied if known.

                      Stack

                      Entry                 Exit


                                                           <- Ptr
                                            +------------+
               Ptr ->                       | Type       |
                      +------------+        |------------|
                      | Name       |        | Name       |
                      |------------|        |------------|
*/

EXTERN void P2SymBuild_BuildSubrange (unsigned int tok, unsigned int Base);

/*
   BuildAligned - builds an alignment constant symbol which is placed onto
                  the stack.  It expects the ident ALIGNED to be on the
                  stack.

                         Stack

                           Entry                 Exit


                  Ptr ->                                            <- Ptr
                         +---------------+      +-----------------+
                         | bytealignment |      | AlignmentConst  |
                         +---------------+      |-----------------|
*/

EXTERN void P2SymBuild_BuildAligned (void);

/*
   BuildVarAlignment - the AlignmentConst is either a temporary or NulSym.
                       A type may only have one alignment value and
                       error checking is performed.

                       Stack

                           Entry                 Exit


                   Ptr ->
                          +-----------------+
                          | AlignmentConst  |                             <- Ptr
                          |-----------------|        +------------------+
                          | Type            |        | Type  | TypeName |
                          |-----------------|        |------------------|
*/

EXTERN void P2SymBuild_BuildVarAlignment (void);

/*
   BuildTypeAlignment - the AlignmentConst is either a temporary or NulSym.
                        A type may only have one alignment value and
                        error checking is performed.

                        Stack

                            Entry                 Exit


                    Ptr ->
                           +-----------------+
                           | AlignmentConst  |
                           |-----------------|
                           | Type            |    Empty
                           |-----------------|
*/

EXTERN void P2SymBuild_BuildTypeAlignment (void);
EXTERN void P2SymBuild_P2BuildDefaultFieldAlignment (void);

/*
   BuildPragmaConst - pushes a constant to the stack and stores it away into the
                      const fifo queue ready for pass 3.
*/

EXTERN void P2SymBuild_BuildPragmaConst (void);

/*
   BuildVariable - Builds variables listed in an IdentList with a Type.

                   Stack

                   Entry                 Exit

            Ptr ->
                   +------------+        +------------+
                   | Type | Name|        |            |
                   |------------|        |------------|
                   | #          |        |            |
                   |------------|        |------------|
                   | Ident 1    |        |            |
                   |------------|        |------------|
                   | Ident 2    |        |            |
                   |------------|        |------------|
                   .            .        .            .
                   .            .        .            .
                   .            .        .            .
                   |------------|        |------------|
                   | Ident #    |        |            | <- Ptr
                   |------------|        |------------|

                                           Empty
*/

EXTERN void P2SymBuild_BuildVariable (void);

/*
   BuildType - Builds a Type.


               Stack

               Entry                 Exit

        Ptr ->
               +------------+
               | Type       |                          <- Ptr
               |------------|        +---------------+
               | Name       |        | Type  | Name  |
               |------------|        |---------------|

                                     Empty
*/

EXTERN void P2SymBuild_BuildType (void);

/*
   StartBuildFormalParameters - Initialises the quadruple stack for
                                Formal Parameters.

                                The Stack:

                                Entry                Exit

                                                                    <- Ptr
                                                     +------------+
                                Empty                | 0          |
                                                     |------------|
*/

EXTERN void P2SymBuild_StartBuildFormalParameters (void);

/*
   EndBuildFormalParameters - Resets the quadruple stack after building
                              Formal Parameters.

                              The Stack:

                              Entry                    Exit

                       Ptr ->
                              +------------+
                              | NoOfParam  |                          <- Ptr
                              |------------|           +------------+
                              | ProcSym    |           | ProcSym    |
                              |------------|           |------------|
*/

EXTERN void P2SymBuild_EndBuildFormalParameters (void);

/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |              Empty
                           |------------|

*/

EXTERN void P2SymBuild_BuildProcedureHeading (void);

/*
   BuildFunction - Builds a procedures return type.
                   Procedure becomes a function.

                    The Stack:

                    Entry                 Exit

             Ptr ->
                    +------------+
                    | TypeSym    |                       <- Ptr
                    |------------|        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

EXTERN void P2SymBuild_BuildFunction (void);

/*
   BuildOptFunction - Builds a procedures optional return type.
                      Procedure becomes a function and the user
                      can either call it as a function or a procedure.

                      The Stack:

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | TypeSym    |                       <- Ptr
                      |------------|        +------------+
                      | ProcSym    |        | ProcSym    |
                      |------------|        |------------|
*/

EXTERN void P2SymBuild_BuildOptFunction (void);

/*
   BuildFPSection - Builds a Formal Parameter in a procedure.

                    The Stack:

                    Entry                 Exit

             Ptr ->
                    +------------+
                    | ParamTotal |
                    |------------|
                    | TypeName   |
                    |------------|
                    | Array/Nul  |
                    |------------|
                    | NoOfIds    |
                    |------------|
                    | Id 1       |
                    |------------|
                    .            .
                    .            .
                    .            .
                    |------------|
                    | Id n       |                       <- Ptr
                    |------------|        +------------+
                    | Var / Nul  |        | ParamTotal |
                    |------------|        |------------|
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

EXTERN void P2SymBuild_BuildFPSection (void);

/*
   BuildVarArgs - indicates that the ProcSym takes varargs
                  after ParamTotal.
                                                         <- Ptr
                    +------------+        +------------+
                    | ParamTotal |        | ParamTotal |
                    |------------|        |------------|
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|

*/

EXTERN void P2SymBuild_BuildVarArgs (void);

/*
   BuildFormalVarArgs - indicates that the procedure type takes varargs.
                                                             <- Ptr
                        +------------+        +------------+
                        | ProcSym    |        | ProcSym    |
                        |------------|        |------------|

*/

EXTERN void P2SymBuild_BuildFormalVarArgs (void);

/*
   BuildOptArg - indicates that the ProcSym takes a single optarg
                 after ParamTotal.

                                                         <- Ptr
                 +------------+        +------------+
                 | ParamTotal |        | ParamTotal |
                 |------------|        |------------|
                 | ProcSym    |        | ProcSym    |
                 |------------|        |------------|
*/

EXTERN void P2SymBuild_BuildOptArg (void);

/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
*/

EXTERN void P2SymBuild_StartBuildProcedure (void);

/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:


                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

EXTERN void P2SymBuild_EndBuildProcedure (void);

/*
   EndBuildForward - ends building a forward procedure.
*/

EXTERN void P2SymBuild_EndBuildForward (void);

/*
   BuildNoReturnAttribute - provide an interface to the symbol table module.
*/

EXTERN void P2SymBuild_BuildNoReturnAttribute (void);

/*
   CheckProcedure - checks to see that the top of stack procedure
                    has not been declared as a procedure function.

                    The Stack:

                    Entry                 Exit

             Ptr ->                                      <- Ptr
                    +------------+        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

EXTERN void P2SymBuild_CheckProcedure (void);

/*
   BuildPointerType - builds a pointer type.
                      The Stack:

                      Entry                       Exit
                      =====                       ====


               Ptr ->                                             <- Ptr
                      +------------+              +-------------+
                      | Type       |              | PointerType |
                      |------------|              |-------------|
                      | Name       |              | Name        |
                      |------------|              |-------------|
*/

EXTERN void P2SymBuild_BuildPointerType (unsigned int pointerpos);

/*
   BuildSetType - builds a set type.
                  The Stack:

                  Entry                       Exit
                  =====                       ====


           Ptr ->                                             <- Ptr
                  +------------+              +-------------+
                  | Type       |              | SetType     |
                  |------------|              |-------------|
                  | Name       |              | Name        |
                  |------------|              |-------------|
*/

EXTERN void P2SymBuild_BuildSetType (unsigned int setpos, bool ispacked);

/*
   BuildRecord - Builds a record type.
                 The Stack:

                 Entry                        Exit
                 =====                        ====

                                                            <- Ptr
                                              +-----------+
          Ptr ->                              | RecordSym |
                 +------------+               |-----------|
                 | Name       |               | Name      |
                 |------------|               |-----------|
*/

EXTERN void P2SymBuild_BuildRecord (void);

/*
   BuildFieldRecord - Builds a field into a record sym.
                      The Stack:


                      Entry                     Exit
                      =====                     ====

               Ptr ->
                      +-------------+
                      | Alignment   |
                      |-------------|
                      | Type | Name |
                      |-------------|
                      | n           |
                      |-------------|
                      | Id 1        |
                      |-------------|
                      .             .
                      .             .
                      .             .
                      |-------------|
                      | Id n        |                           <- Ptr
                      |-------------|           +-------------+
                      | RecordSym   |           | RecordSym   |
                      |-------------|           |-------------|
                      | RecordName  |           | RecordName  |
                      |-------------|           |-------------|
*/

EXTERN void P2SymBuild_BuildFieldRecord (void);

/*
   StartBuildVarient - Builds a varient symbol on top of a record sym.
                       The Stack:


                       Entry                     Exit
                       =====                     ====

                                                                 <- Ptr
                                                 +-------------+
                Ptr ->                           | VarientSym  |
                       +-------------+           |-------------|
                       | RecordSym   |           | RecordSym   |
                       |-------------|           |-------------|
                       | RecordName  |           | RecordName  |
                       |-------------|           |-------------|
*/

EXTERN void P2SymBuild_StartBuildVarient (void);

/*
   EndBuildVarient - Removes the varient symbol from the stack.
                     The Stack:

                     Entry                     Exit
                     =====                     ====

              Ptr ->
                     +-------------+
                     | VarientSym  |                           <- Ptr
                     |-------------|           +-------------+
                     | RecordSym   |           | RecordSym   |
                     |-------------|           |-------------|
                     | RecordName  |           | RecordName  |
                     |-------------|           |-------------|
*/

EXTERN void P2SymBuild_EndBuildVarient (void);

/*
   BuildVarientSelector - Builds a field into a record sym.
                          The Stack:


                          Entry                     Exit
                          =====                     ====

                   Ptr ->
                          +-------------+
                          | Qualident   |
                          |-------------|
                          | Ident       |                           <- Ptr
                          |-------------|           +-------------+
                          | RecordSym   |           | RecordSym   |
                          |-------------|           |-------------|
*/

EXTERN void P2SymBuild_BuildVarientSelector (void);

/*
   StartBuildVarientFieldRecord - Builds a varient field into a varient sym.
                                  The Stack:


                                  Entry                     Exit
                                  =====                     ====

                                                                       <- Ptr
                                                       +-------------+
                      Ptr ->                           | VarientField|
                             +-------------+           |-------------|
                             | VarientSym  |           | RecordSym   |
                             |-------------|           |-------------|
*/

EXTERN void P2SymBuild_StartBuildVarientFieldRecord (void);

/*
   EndBuildVarientFieldRecord - Removes a varient field from the stack.
                                The Stack:


                                Entry                     Exit
                                =====                     ====

                         Ptr ->
                                +-------------+
                                | VarientField|                           <- Ptr
                                |-------------|           +-------------+
                                | VarientSym  |           | VarientSym  |
                                |-------------|           |-------------|
*/

EXTERN void P2SymBuild_EndBuildVarientFieldRecord (void);

/*
   BuildNulName - Pushes a NulKey onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulKey     |
                                           |------------|
*/

EXTERN void P2SymBuild_BuildNulName (void);

/*
   BuildTypeEnd - Pops the type Type and Name.
                  The Stack:


                  Entry                    Exit


           Ptr ->
                  +-------------+
                  | Type | Name |          Empty
                  |-------------|
*/

EXTERN void P2SymBuild_BuildTypeEnd (void);

/*
   StartBuildArray - Builds an array type.
                     The Stack:

                     Entry                        Exit
                     =====                        ====

                                                                <- Ptr
                                                  +-----------+
              Ptr ->                              | ArraySym  |
                     +------------+               |-----------|
                     | Name       |               | Name      |
                     |------------|               |-----------|
*/

EXTERN void P2SymBuild_StartBuildArray (void);

/*
   EndBuildArray - Builds an array type.
                   The Stack:

                   Entry                        Exit
                   =====                        ====

            Ptr ->
                   +------------+
                   | TypeSym    |                              <- Ptr
                   |------------|               +------------+
                   | ArraySym   |               | ArraySym   |
                   |------------|               |------------|
                   | Name       |               | Name       |
                   |------------|               |------------|
*/

EXTERN void P2SymBuild_EndBuildArray (void);

/*
   BuildFieldArray - Builds a field into an array sym.
                     The Stack:


                     Entry                     Exit
                     =====                     ====

              Ptr ->
                     +-------------+
                     | Type | Name |                           <- Ptr
                     |-------------|           +-------------+
                     | ArraySym    |           | ArraySym    |
                     |-------------|           |-------------|
                     | ArrayName   |           | ArrayName   |
                     |-------------|           |-------------|
*/

EXTERN void P2SymBuild_BuildFieldArray (void);

/*
   BuildArrayComma - converts ARRAY [..], [..] OF into ARRAY [..] OF ARRAY [..]


              Ptr ->                                           <- Ptr
                     +-------------+           +-------------+
                     | ArraySym1   |           | ArraySym2   |
                     |-------------|           |-------------|
                     | ArrayName   |           | ArrayName   |
                     |-------------|           |-------------|
*/

EXTERN void P2SymBuild_BuildArrayComma (void);

/*
   BuildProcedureType - builds a procedure type symbol.
                        The Stack:


                                                               <- Ptr
                                               +-------------+
                 Ptr ->                        | ProcTypeSym |
                        +-------------+        |-------------|
                        | Name        |        | Name        |
                        |-------------|        |-------------|
*/

EXTERN void P2SymBuild_BuildProcedureType (void);

/*
   BuildFormalType - Builds a Formal Parameter in a procedure type.

                     The Stack:

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | TypeSym    |
                     |------------|
                     | Array/Nul  |
                     |------------|
                     | Var / Nul  |                         <- Ptr
                     |------------|        +--------------+
                     | ProcTypeSym|        | ProcTypeSym  |
                     |------------|        |--------------|
*/

EXTERN void P2SymBuild_BuildFormalType (void);

/*
   SeenUnknown - sets the operand type to unknown.
*/

EXTERN void P2SymBuild_SeenUnknown (void);

/*
   SeenCast - sets the operand type to cast.
*/

EXTERN void P2SymBuild_SeenCast (unsigned int sym);

/*
   SeenSet - sets the operand type to set.
*/

EXTERN void P2SymBuild_SeenSet (void);

/*
   SeenConstructor - sets the operand type to constructor.
*/

EXTERN void P2SymBuild_SeenConstructor (void);

/*
   SeenArray - sets the operand type to array.
*/

EXTERN void P2SymBuild_SeenArray (void);

/*
   SeenString - sets the operand type to string.
*/

EXTERN void P2SymBuild_SeenString (void);

/*
   SeenBoolean - sets the operand type to a BOOLEAN.
*/

EXTERN void P2SymBuild_SeenBoolean (void);

/*
   SeenZType - sets the operand type to a Z type.
*/

EXTERN void P2SymBuild_SeenZType (void);

/*
   SeenRType - sets the operand type to a R type.
*/

EXTERN void P2SymBuild_SeenRType (void);

/*
   SeenCType - sets the operand type to a C type.
*/

EXTERN void P2SymBuild_SeenCType (void);

/*
   DetermineType - assigns the top of stack symbol with the type of
                   constant expression, if known.
*/

EXTERN void P2SymBuild_DetermineType (void);

/*
   PushType - pushes the current constant type.
*/

EXTERN void P2SymBuild_PushType (void);

/*
   PopType - pops the stacked type.
*/

EXTERN void P2SymBuild_PopType (void);

/*
   PushRememberConstant -
*/

EXTERN void P2SymBuild_PushRememberConstant (void);

/*
   PopRememberConstant -
*/

EXTERN void P2SymBuild_PopRememberConstant (void);

/*
   RememberConstant -
*/

EXTERN void P2SymBuild_RememberConstant (unsigned int sym);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
