/* do not edit automatically generated by mc from P1SymBuild.  */
/* P1SymBuild.def pass 1 symbol creation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_P1SymBuild_H)
#   define _P1SymBuild_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif


#   if defined (_P1SymBuild_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

EXTERN void P1SymBuild_P1StartBuildDefinitionModule (void);
EXTERN void P1SymBuild_P1EndBuildDefinitionModule (void);
EXTERN void P1SymBuild_P1StartBuildImplementationModule (void);
EXTERN void P1SymBuild_P1EndBuildImplementationModule (void);
EXTERN void P1SymBuild_P1StartBuildProgramModule (void);
EXTERN void P1SymBuild_P1EndBuildProgramModule (void);

/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

EXTERN void P1SymBuild_StartBuildInnerModule (void);
EXTERN void P1SymBuild_EndBuildInnerModule (void);

/*
   BuildImportOuterModule - Builds imported identifiers into an outer module
                            from a definition module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                                                  Error Condition
                            Exit

                            All above stack discarded
*/

EXTERN void P1SymBuild_BuildImportOuterModule (bool definition);

/*
   BuildExportOuterModule - Builds exported identifiers from an outer module
                            to the outside world of library modules.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;

                            Error Condition


                            Exit

                            All above stack discarded
*/

EXTERN void P1SymBuild_BuildExportOuterModule (void);

/*
   CheckExplicitExported - checks to see whether we are compiling
                           a definition module and whether the ident
                           is implicitly export qualified or unqualified.


                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                Ptr ->
                           +------------+        +-----------+
                           | Identname  |        | Identname |
                           |------------|        |-----------|

*/

EXTERN void P1SymBuild_CheckExplicitExported (void);

/*
   BuildImportInnerModule - Builds imported identifiers into an inner module
                            from the last level of module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                                                  Error Condition
                            Exit

                            All above stack discarded
*/

EXTERN void P1SymBuild_BuildImportInnerModule (void);

/*
   BuildExportInnerModule - Builds exported identifiers from an inner module
                            to the next layer module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

EXTERN void P1SymBuild_BuildExportInnerModule (void);

/*
   StartBuildEnumeration - Builds an Enumeration type Type.


                           Stack

                           Entry                 Exit

                    Ptr ->
                           +------------+
                           | #          |
                           |------------|
                           | en 1       |
                           |------------|
                           | en 2       |
                           |------------|
                           .            .
                           .            .
                           .            .                       <- Ptr
                           |------------|        +------------+
                           | en #       |        | Type       |
                           |------------|        |------------|
                           | Name       |        | Name       |
                           |------------|        |------------|
*/

EXTERN void P1SymBuild_StartBuildEnumeration (void);

/*
   EndBuildEnumeration - completes the construction of the enumeration type.


                         Stack

                         Entry                 Exit

                  Ptr ->
                         +------------+
                         | Type       |                          <- Ptr
                         |------------|        +---------------+
                         | Name       |        | Type  | Name  |
                         |------------|        |---------------|

                                               Empty
*/

EXTERN void P1SymBuild_EndBuildEnumeration (void);

/*
   BuildHiddenType - Builds a Hidden Type.


                     Stack

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | Name       |                          <- Ptr
                     |------------|        Empty
*/

EXTERN void P1SymBuild_BuildHiddenType (void);

/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
*/

EXTERN void P1SymBuild_StartBuildProcedure (void);

/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:


                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

EXTERN void P1SymBuild_EndBuildProcedure (void);

/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |              Empty
                           |------------|

*/

EXTERN void P1SymBuild_BuildProcedureHeading (void);

/*
   EndBuildForward - Ends building a forward procedure declaration.

                     The Stack:

                     (This procedure is not defined in definition module)

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | ProcSym    |
                     |------------|
                     | NameStart  |
                     |------------|
                                           Empty
*/

EXTERN void P1SymBuild_EndBuildForward (unsigned int forwardPos);

/*
   BuildNulName - Pushes a NulKey onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulKey     |
                                           |------------|
*/

EXTERN void P1SymBuild_BuildNulName (void);

/*
   BuildTypeEnd - Pops the type Type and Name.
                  The Stack:


                  Entry                    Exit


           Ptr ->
                  +-------------+
                  | Type | Name |          Empty
                  |-------------|
*/

EXTERN void P1SymBuild_BuildTypeEnd (void);

/*
   BuildImportStatement - create a new import statement in the current module.
                          It ignores local modules.

                          The quadruple stack is not used.
*/

EXTERN void P1SymBuild_BuildImportStatement (unsigned int tok);

/*
   AddImportToImportStatement - the top of stack is expected to be a module name.
                                This is looked up from the module universe and
                                wrapped in an import symbol and placed into the
                                current import statement.

                                The quadruple stack is unchanged.

                                Entry                      Exit


                         Ptr ->                                                   <- Ptr
                                +---------------------+   +---------------------+
                                | ImportedModuleName  |   | ImportedModuleName  |
                                |---------------------|   |---------------------|
*/

EXTERN void P1SymBuild_AddImportToImportStatement (bool qualified);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
