/* do not edit automatically generated by mc from M2LexBuf.  */
/* M2LexBuf.def provides a buffer for m2.flex.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2LexBuf_H)
#   define _M2LexBuf_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "GM2Reserved.h"
#   include "GDynamicStrings.h"
#   include "Ggcctypes.h"
#   include "GNameKey.h"

#   if defined (_M2LexBuf_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#   define M2LexBuf_UnknownTokenNo 0
#   define M2LexBuf_BuiltinTokenNo 1
EXTERN M2Reserved_toktype M2LexBuf_currenttoken;
EXTERN void * M2LexBuf_currentstring;
EXTERN unsigned int M2LexBuf_currentcolumn;
EXTERN int M2LexBuf_currentinteger;

/*
   OpenSource - Attempts to open the source file, s.
                The success of the operation is returned.
*/

EXTERN bool M2LexBuf_OpenSource (DynamicStrings_String s);

/*
   CloseSource - closes the current open file.
*/

EXTERN void M2LexBuf_CloseSource (void);

/*
   ReInitialize - re-initialize the all the data structures.
*/

EXTERN void M2LexBuf_ReInitialize (void);

/*
   ResetForNewPass - reset the buffer pointers to the beginning ready for
                     a new pass
*/

EXTERN void M2LexBuf_ResetForNewPass (void);

/*
   GetToken - gets the next token into currenttoken.
*/

EXTERN void M2LexBuf_GetToken (void);

/*
   InsertToken - inserts a symbol, token, infront of the current token
                 ready for the next pass.
*/

EXTERN void M2LexBuf_InsertToken (M2Reserved_toktype token);

/*
   InsertTokenAndRewind - inserts a symbol, token, infront of the current token
                          and then moves the token stream back onto the inserted token.
*/

EXTERN void M2LexBuf_InsertTokenAndRewind (M2Reserved_toktype token);

/*
   GetPreviousTokenLineNo - returns the line number of the previous token.
*/

EXTERN unsigned int M2LexBuf_GetPreviousTokenLineNo (void);

/*
   GetLineNo - returns the current line number where the symbol occurs in
               the source file.
*/

EXTERN unsigned int M2LexBuf_GetLineNo (void);

/*
   GetTokenNo - returns the current token number.
*/

EXTERN unsigned int M2LexBuf_GetTokenNo (void);

/*
   GetTokenName - returns the token name given the tokenno.
*/

EXTERN NameKey_Name M2LexBuf_GetTokenName (unsigned int tokenno);

/*
   TokenToLineNo - returns the line number of the current file for the
                   tokenno. The depth refers to the include depth.
                   A depth of 0 is the current file, depth of 1 is the file
                   which included the current file. Zero is returned if the
                   depth exceeds the file nesting level.
*/

EXTERN unsigned int M2LexBuf_TokenToLineNo (unsigned int tokenno, unsigned int depth);

/*
   GetColumnNo - returns the current column where the symbol occurs in
                 the source file.
*/

EXTERN unsigned int M2LexBuf_GetColumnNo (void);

/*
   TokenToColumnNo - returns the column number of the current file for the
                     tokenno. The depth refers to the include depth.
                     A depth of 0 is the current file, depth of 1 is the file
                     which included the current file. Zero is returned if the
                     depth exceeds the file nesting level.
*/

EXTERN unsigned int M2LexBuf_TokenToColumnNo (unsigned int tokenno, unsigned int depth);

/*
   TokenToLocation - returns the location_t corresponding to tokenno.
*/

EXTERN location_t M2LexBuf_TokenToLocation (unsigned int tokenno);

/*
   FindFileNameFromToken - returns the complete FileName for the appropriate
                           source file yields the token number tokenno.
                           The, Depth, indicates the include level: 0..n
                           Level 0 is the current. NIL is returned if n+1
                           is requested.
*/

EXTERN DynamicStrings_String M2LexBuf_FindFileNameFromToken (unsigned int tokenno, unsigned int depth);

/*
   GetFileName - returns a String defining the current file.
*/

EXTERN DynamicStrings_String M2LexBuf_GetFileName (void);

/*
   MakeVirtualTok - providing caret, left, right are associated with a source file
                    and exist on the same src line then
                    create and return a new tokenno which is created from
                    tokenno left and right.  Otherwise return caret.
                    If caret is UnknownTokenNo then it is replaced with left or right
                    in sequence to avoid an UnknownTokenNo.
*/

EXTERN unsigned int M2LexBuf_MakeVirtualTok (unsigned int caret, unsigned int left, unsigned int right);

/*
   MakeVirtual2Tok - creates and return a new tokenno which is created from
                     two tokens left and right.  It tries to avoid UnknownTokenNo
                     and will fall back to left or right if necessary.
*/

EXTERN unsigned int M2LexBuf_MakeVirtual2Tok (unsigned int left, unsigned int right);

/*
   AddTok - adds a token to the buffer.
*/

EXTERN void M2LexBuf_AddTok (M2Reserved_toktype t);

/*
   AddTokCharStar - adds a token to the buffer and an additional string, s.
                    A copy of string, s, is made.
*/

EXTERN void M2LexBuf_AddTokCharStar (M2Reserved_toktype t, void * s);

/*
   AddTokInteger - adds a token and an integer to the buffer.
*/

EXTERN void M2LexBuf_AddTokInteger (M2Reserved_toktype t, int i);

/*
   SetFile - sets the current filename to, filename.
*/

EXTERN void M2LexBuf_SetFile (void * filename);

/*
   PushFile - indicates that, filename, has just been included.
*/

EXTERN void M2LexBuf_PushFile (void * filename);

/*
   PopFile - indicates that we are returning to, filename, having finished
             an include.
*/

EXTERN void M2LexBuf_PopFile (void * filename);

/*
   PrintTokenNo - displays token and the location of the token.
*/

EXTERN void M2LexBuf_PrintTokenNo (unsigned int tokenno);

/*
   DisplayToken - display the token name using printf0 no newline is emitted.
*/

EXTERN void M2LexBuf_DisplayToken (M2Reserved_toktype tok);

/*
   DumpTokens - displays all tokens.
*/

EXTERN void M2LexBuf_DumpTokens (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
